/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.sample;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.common.util.DateUtils;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.TestTable;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.action.BaseDownloadAction;
import org.jtp.web.action.Paging;

/**
 * 検索画面アクションクラスです。
 * 
 * @struts.action
 *  name="sample/InputForm"
 *  path="/sample/search"
 *  scope="request"
 *  validate="true"
 *  input="/sample/search.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="success"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/jsp/common/menu.jsp"
 * @struts.action-forward
 *  name="update"
 *  path="/sample/update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/sample/remove.tiles"
 * @struts.action-forward
 *  name="download"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/sample/search.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SearchAction extends BaseDownloadAction implements Paging {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SearchAction.class);

    /** テストテーブル情報サービス */
    private TestTableService testTableService;

    
    /**
     * テストテーブル情報サービスを設定します。
     * @param testTableService テストテーブル情報サービス
     */
	public void setTestTableService(TestTableService testTableService) {
		this.testTableService = testTableService;
	}

	/**
	 * 登録アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward save(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		TestTable condition = new TestTable();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), condition);
		
		_log.info("save");
		
		testTableService.save(condition);
		
		getSession(request).setAttribute("list", testTableService.find(new TestTable()));

    	return mapping.findForward(FORWARD_SUCCESS);
    }
    
    /**
     * 検索アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward search(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		TestTable condition = new TestTable();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), condition);
		
		List result = testTableService.find(condition);
		
		getSession(request).setAttribute("list", result);
		request.setAttribute("testTable", condition);

    	return mapping.findForward(FORWARD_SUCCESS);
    }
    
    /**
     * 更新アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward update(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("list");
    	request.setAttribute("testTable", list.get(index));
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 削除アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward remove(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("list");
    	request.setAttribute("testTable", list.get(index));
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 戻るアクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward cancelled(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
    	getSession(request).removeAttribute("list");
    	return super.cancelled(mapping, form, request, response);
    }
	
    /**
     * 表示ファイル名を取得します。
     * @return 表示ファイル名
     */
	protected String getDisplayName() {
		return "ほげ.txt";
	}

    /**
     * ダウンロードファイルの入力ストリームを取得します。
     * @param form 存在するならば、このリクエストのためのActionForm Bean
     * @param request 処理しているHTTPリクエスト
     * @param session 処理しているHTTPセッション
     * @return ダウンロードファイルの入力ストリーム
     * @throws FileNotFoundException 指定されたパス名で示されるファイルが開けなかったことを通知する例外
     * @throws UnsupportedEncodingException 文字のエンコーディングがサポートされないことを通知する例外
     */
    protected InputStream getDownloadStream(ActionForm form,
    		HttpServletRequest request) throws FileNotFoundException, UnsupportedEncodingException {

		String path = getServletContext().getRealPath("hoge.txt");
		
		//文字コード（SHIFT_JIS）指定でファイル出力
		PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path), SJIS)));
		
		List list = (List) getSession(request).getAttribute("list");

		StringBuffer buffer = new StringBuffer();

		for (Iterator it = list.iterator(); it.hasNext();) {
			TestTable testTable = (TestTable) it.next();
			buffer.append(testTable.getId());
			buffer.append(",");
			buffer.append(testTable.getHoge1());
			buffer.append(",");
			buffer.append(testTable.getHoge2());
			buffer.append(",");
			buffer.append(testTable.getHoge3());
			buffer.append(",");
			buffer.append(DateUtils.dateToString(testTable.getCreateDate()));
			buffer.append(",");
			buffer.append(DateUtils.dateToString(testTable.getUpdateDate()));
			
			pw.println(buffer.toString());
			buffer.delete(0, buffer.toString().length());
		}
		
		pw.close();
		
		return new FileInputStream(path);
	}

	/**
	 * 改頁アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward page(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		TestTable condition = (TestTable) request.getSession().getAttribute("testTable");
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), condition);

		//改頁後の頁番号をリクエストに設定する
		request.setAttribute(PAGE_NUMBER, request.getParameter(PAGE_NUMBER));
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
	}
}
