/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.bean;

import java.io.Serializable;


/**
 * 改ページ設定情報格納クラス
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2007/04/04 16:58:32 $
 * @since 2.0 (Oct,26,2006)
 */
@SuppressWarnings("serial")
public class PagingBean implements Serializable {

	/** ID */
	public static final String ID = "pagingBean";
	
	/** 現在頁 */
	private int current;
	/** 前頁 */
	private int prev;
	/** 次頁 */
	private int next;
	/** 総頁 */
	private int all;
	/** 開始インデックス */
	private int offset;
	/** 終了インデックス */
	private int length;
	/** データ件数 */
	private int count;
	
	/**
	 * 現在頁の取得
	 * @return 現在頁
	 */
	public int getCurrent() {
		return current;
	}
	
	/**
	 * 現在頁の設定
	 * @param current 現在頁
	 */
	public void setCurrent(int current) {
		this.current = current;
	}
	
	/**
	 * 前頁の取得
	 * @return 前頁
	 */
	public int getPrev() {
		return prev;
	}
	
	/**
	 * 前頁の設定
	 * @param prev 前頁
	 */
	public void setPrev(int prev) {
		this.prev = prev;
	}
	
	/**
	 * 次頁の取得
	 * @return 次頁
	 */
	public int getNext() {
		return next;
	}
	
	/**
	 * 次頁の設定
	 * @param next 次頁
	 */
	public void setNext(int next) {
		this.next = next;
	}

	/**
	 * 総頁の取得
	 * @return 総頁
	 */
	public int getAll() {
		return all;
	}
	
	/**
	 * 総頁の設定
	 * @param all 総頁
	 */
	public void setAll(int all) {
		this.all = all;
	}
	
	/**
	 * 開始インデックスの取得
	 * @return 開始インデックス
	 */
	public int getOffset() {
		return offset;
	}
	
	/**
	 * 開始インデックスの設定
	 * @param offset 開始インデックス
	 */
	public void setOffset(int offset) {
		this.offset = offset;
	}
	
	/**
	 * 終了インデックスの取得
	 * @return 終了インデックス
	 */
	public int getLength() {
		return length;
	}
	
	/**
	 * 終了インデックスの設定
	 * @param length 終了インデックス
	 */
	public void setLength(int length) {
		this.length = length;
	}
	
	/**
	 * データ件数の取得
	 * @return データ件数
	 */
	public int getCount() {
		return count;
	}
	
	/**
	 * データ件数の設定
	 * @param count データ件数
	 */
	public void setCount(int count) {
		this.count = count;
	}
}
