/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity;


/**
 * テストテーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="test_table"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *   auto-import = "true"
 * 
 * @hibernate.query
 *   name = "testTableList"
 *   query = "
 *      select testTable
 *        from TestTable testTable
 *       where (:id < 0 or testTable.id = :id)
 *         and (:hoge1 is null or testTable.hoge1 like :hoge1)
 *         and (:hoge2 is null or testTable.hoge2 like :hoge2)
 *         and (:hoge3 is null or testTable.hoge3 like :hoge3)
 *      order by testTable.id
 *   "
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class TestTable extends AuditableEntity {

    /** identifier field */
    private Integer id;

    /** nullable persistent field */
    private String hoge1;

    /** nullable persistent field */
    private String hoge2;

    /** nullable persistent field */
    private String hoge3;


    /** default constructor */
    public TestTable() {
    }

    /** minimal constructor */
    public TestTable(Integer id) {
        this.id = id;
    }

    /**
     * @hibernate.id
     *  generator-class="identity"
     *  type="java.lang.Integer"
     *  column="id"
     */
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="hoge1"
     */
    public String getHoge1() {
        return this.hoge1;
    }

    public void setHoge1(String hoge1) {
        this.hoge1 = hoge1;
    }

    /** 
     * @hibernate.property
     *  column="hoge2"
     */
    public String getHoge2() {
        return this.hoge2;
    }

    public void setHoge2(String hoge2) {
        this.hoge2 = hoge2;
    }

    /** 
     * @hibernate.property
     *  column="hoge3"
     */
    public String getHoge3() {
        return this.hoge3;
    }

    public void setHoge3(String hoge3) {
        this.hoge3 = hoge3;
    }
}
