/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.menu;

import javax.faces.FacesException;
import javax.faces.event.ActionEvent;

import org.jtp.web.WebContext;
import org.jtp.web.sample.SampleBean;


/**
 * メニュー画面イベントを処理するマネージドビーンクラスです。 
 * 
 * @jsf.bean
 *   name = "menuAction"
 *   scope = "request"   
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MenuAction {
	
	/**
	 * メニューアクションを処理します。
     * @param event イベント
     * @throws FacesException JSF例外
	 */
	public void success(ActionEvent event) throws FacesException {
		WebContext.getHttpSession().removeAttribute(SampleBean.ATTRIBUTE_NAME);
    }
}
