/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.form;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;


import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.TestTable;

/**
 * アクションフォームクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class SampleActionForm extends DynaValidatorActionForm {

	/**
	 * HTTPリクエストにセットされているプロパティの妥当性を検証して、
	 * 見つかった全ての検証エラーをカプセル化した ActionErrorsオブジェクトを返します。
	 * エラーが見つからなかった場合はnullもしくはエラーメッセージが何も記録されていない
	 * ActionErrorsオブジェクトを返します。
	 *
	 * @param mapping このインスタンスを選択するために使用したActionMapping
	 * @param request 処理しているHTTPリクエスト
	 * @return ActionErrorsオブジェクト
	 */
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		
		//関連付けられたプロパティの妥当性を検証する
		ActionErrors errors = super.validate(mapping, request);
		
		//エラーがある場合
		if (!errors.isEmpty()) {
			//画面内容をリクエストに設定する
			requestFormProperty(request);
		}
		
		return errors;
	}
	
	/**
	 * 妥当性の検証エラーがある場合、画面内容をリクエストに設定する
	 * @param request 処理しているHTTPリクエスト
	 */
	protected void requestFormProperty(HttpServletRequest request) {
		TestTable testTable = new TestTable();
		PropertyUtilsWrapper.copyProperties(getMap(), testTable);
		String id = request.getParameter("id");
		if (StringUtils.isNotEmpty(id)) {
			testTable.setId(Integer.valueOf(id));
			List list = (List) request.getSession().getAttribute("list");
			for (Iterator it = list.iterator(); it.hasNext();) {
				TestTable entity = (TestTable) it.next();
				if (testTable.getId().intValue() == entity.getId().intValue()) {
					testTable.setCreateDate(entity.getCreateDate());
					testTable.setUpdateDate(entity.getUpdateDate());
					break;
				}
			}
		}
		request.setAttribute("testTable", testTable);
	}
}
