/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.taglib.html.Constants;
import org.jtp.web.exception.TimeoutException;
import org.jtp.web.exception.TokenValidException;

/**
 * 例外処理をハンドリングするクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SampleExceptionHandler extends ExceptionHandler {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(SampleExceptionHandler.class);

	/**
	 * 例外を処理し、指定された画面に遷移します。
	 * @param ex 処理する例外
	 * @param config 例外に対応するExceptionConfig
	 * @param mapping 処理するActionMapping
	 * @param form 処理するActionForm
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
	 * @throws ServletException サーブレット例外
	 */
    @Override
	public ActionForward execute(Exception ex, ExceptionConfig config,
            ActionMapping mapping, ActionForm form, HttpServletRequest request, 
            HttpServletResponse response) throws ServletException {
		
	      ActionForward forward = super.execute(ex, config, mapping, form, request, response);

	      String property = null;
	      ActionMessage message = null;
	      
	      //タイムアウトの場合
	      if (ex instanceof TimeoutException) {
	    	  property = "timeout";
	    	  message = new ActionMessage("msg.timeout");
	      }
	      //トークンエラーの場合
	      else if (ex instanceof TokenValidException) {
	    	  property = "error";
	    	  message = new ActionMessage("msg.token");
	    	  _log.info("request: " + request.getParameter(Constants.TOKEN_KEY));
	    	  _log.info("session: " + request.getSession().getAttribute(Globals.TRANSACTION_TOKEN_KEY));
	      }
	      //以外の場合
	      else {
	    	  property = "error";
	    	  if (ex.getMessage() != null) {
		    	  message = new ActionMessage("errors.msg", ex.getMessage());
	    	  }
	    	  else {
		    	  message = new ActionMessage("errors.msg.error", mapping.getType(), ex.toString());
	    	  }
	      }

	      _log.error(ex.getMessage(), ex);
	      
	      storeException(request, property, message, forward, config.getScope());
	      
	      return forward;
	}
}
