/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAccountTable;
import org.jtp.logic.mail.MailAccountTableService;
import org.jtp.web.action.BaseAction;

/**
 * アカウント設定画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/account"
 *  scope="request"
 *  validate="true"
 *  input="/mail/account.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="save"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="update"
 *  path="/mail/account_update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/mail/account.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class AccountAction extends BaseAction {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(AccountAction.class);

    /** アカウントテーブル情報サービス */
    private MailAccountTableService mailAccountTableService;

    /**
     * アカウントテーブル情報サービスを設定します。
     * @param mailAccountTableService アカウントテーブル情報サービス
     */
	public void setMailAccountTableService(MailAccountTableService mailAccountTableService) {
		this.mailAccountTableService = mailAccountTableService;
	}

	/**
	 * 登録アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward save(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		MailAccountTable entity = new MailAccountTable();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), entity);
		
		_log.info("save");
		
		mailAccountTableService.save(entity);
		
		_log.info("search");

		List result = mailAccountTableService.findAll();
		getSession(request).setAttribute("accountList", result);

    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }

	/**
	 * 更新アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward update(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("accountList");
    	MailAccountTable mailAccountTable = (MailAccountTable) list.get(index);
     	request.setAttribute("mailAccountTable", mailAccountTable);
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 削除アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward remove(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("accountList");
    	MailAccountTable entity = (MailAccountTable) list.get(index);
		
		_log.info("delete");
    	mailAccountTableService.delete(entity);

		_log.info("search");
		List result = mailAccountTableService.findAll();
		getSession(request).setAttribute("accountList", result);

		return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }

	/**
	 * トークン確認を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	@Override
	protected boolean isSkipTokenValid(HttpServletRequest request) {
		return true;
	}
}
