/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAccountTable;
import org.jtp.logic.mail.MailAccountTableService;
import org.jtp.web.action.BaseAction;

/**
 * アカウント変更画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/accountUpdate"
 *  scope="request"
 *  validate="true"
 *  input="/mail/account.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="success"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/mail/account.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class AccountUpdateAction extends BaseAction {

    /** アカウントテーブル情報サービス */
    private MailAccountTableService mailAccountTableService;

    /**
     * アカウントテーブル情報サービスを設定します。
     * @param mailAccountTableService アカウントテーブル情報サービス
     */
	public void setMailAccountTableService(MailAccountTableService mailAccountTableService) {
		this.mailAccountTableService = mailAccountTableService;
	}

	/**
	 * 更新アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward success(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		Integer id = new Integer(request.getParameter("id"));

		MailAccountTable entity = null;

		List list = (List) request.getSession().getAttribute("accountList");
		for (Iterator it = list.iterator(); it.hasNext();) {
			entity = (MailAccountTable) it.next();
			if (entity.getId().intValue() == id.intValue()) {
				PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), entity);
				break;
			}
		}
		
		mailAccountTableService.update(entity);

    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
}
