/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAddressTable;
import org.jtp.logic.mail.MailAddressTableService;
import org.jtp.web.action.BaseAction;

/**
 * アドレス帳設定画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/address"
 *  scope="request"
 *  validate="true"
 *  input="/mail/address.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="save"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="update"
 *  path="/mail/address_update.tiles"
 * @struts.action-forward
 *  name="remove"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/mail/address.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class AddressAction extends BaseAction {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(AddressAction.class);

    /** メールアドレステーブル情報サービス */
    private MailAddressTableService mailAddressTableService;

    /**
     * メールアドレステーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailAddressTableService(MailAddressTableService mailAddressTableService) {
		this.mailAddressTableService = mailAddressTableService;
	}

	/**
	 * 登録アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward save(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		MailAddressTable entity = new MailAddressTable();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), entity);
		
		_log.info("save");
		
		mailAddressTableService.save(entity);
		
		_log.info("search");

		List result = mailAddressTableService.findAll();
		getSession(request).setAttribute("addressList", result);

    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }

	/**
	 * 更新アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward update(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("addressList");
    	MailAddressTable mailAddressTable = (MailAddressTable) list.get(index);
     	request.setAttribute("mailAddressTable", mailAddressTable);
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 削除アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward remove(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("addressList");
    	MailAddressTable mailAddressTable = (MailAddressTable) list.get(index);
		
		_log.info("delete");
    	mailAddressTableService.delete(mailAddressTable);

		_log.info("search");
		List result = mailAddressTableService.findAll();
		getSession(request).setAttribute("addressList", result);

		return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }

	/**
	 * トークン確認を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	@Override
	protected boolean isSkipTokenValid(HttpServletRequest request) {
		return true;
	}
}
