/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.form;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.test.TestTable;

/**
 * アクションフォームクラスです。
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class SampleActionForm extends BaseActionForm {
	
	/**
	 * 妥当性の検証エラーがある場合、画面内容をリクエストに設定する
	 * @param request 処理しているHTTPリクエスト
	 */
	protected void requestFormProperty(HttpServletRequest request) {
		TestTable testTable = new TestTable();
		PropertyUtilsWrapper.copyProperties(getMap(), testTable);
		String id = request.getParameter("id");
		if (StringUtils.isNotEmpty(id)) {
			testTable.setId(Integer.valueOf(id));
			List list = (List) request.getSession().getAttribute("list");
			for (Iterator it = list.iterator(); it.hasNext();) {
				TestTable entity = (TestTable) it.next();
				if (testTable.getId().intValue() == entity.getId().intValue()) {
					testTable.setCreateDate(entity.getCreateDate());
					testTable.setUpdateDate(entity.getUpdateDate());
					break;
				}
			}
		}
		request.setAttribute("testTable", testTable);
	}
}
