/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity.mail;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jtp.entity.AuditableEntity;


/**
 * 添付メールテーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="mail_attach_table"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *  auto-import = "true"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailAttachTable extends AuditableEntity {

    /** identifier field */
    private MailAttachTablePK id;

    /** persistent field */
    private byte[] attach;

    /** persistent field */
    private String attachName;


    /** default constructor */
    public MailAttachTable() {
    }

    /** minimal constructor */
    public MailAttachTable(MailAttachTablePK id, byte[] attach, String attachName) {
        this.id = id;
        this.attach = attach;
        this.attachName = attachName;
    }

    /**
     * @hibernate.id
     */
    public MailAttachTablePK getId() {
        return this.id;
    }

    public void setId(MailAttachTablePK id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="attach"
     */
    public byte[] getAttach() {
        return this.attach;
    }

    public void setAttach(byte[] attach) {
        this.attach = attach;
    }

    /** 
     * @hibernate.property
     *  column="attach_name"
     */
    public String getAttachName() {
        return this.attachName;
    }

    public void setAttachName(String attachName) {
        this.attachName = attachName;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof MailAttachTable) ) return false;
        MailAttachTable castOther = (MailAttachTable) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }
}
