/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity.mail;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jtp.entity.AuditableEntity;


/**
 * CCメールテーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="mail_cc_table"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *  auto-import = "true"
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailCcTable extends AuditableEntity {

    /** identifier field */
    private MailCcTablePK id;

    /** nullable persistent field */
    private String cc;


    /** default constructor */
    public MailCcTable() {
    }

    /** minimal constructor */
    public MailCcTable(MailCcTablePK id) {
        this.id = id;
    }

    /**
     * @hibernate.id
     */
    public MailCcTablePK getId() {
        return this.id;
    }

    public void setId(MailCcTablePK id) {
        this.id = id;
    }

    /** 
     * @hibernate.property
     *  column="cc"
     */
    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof MailCcTable) ) return false;
        MailCcTable castOther = (MailCcTable) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }
}
