/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.entity.mail.MailTable;


/**
 * データアクセスインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public interface MailTableDao {
    
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List findHistory() throws SampleException;
    
	/**
	 * 登録します。
	 * @param mailTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailTable mailTable) throws SampleException;
}
