/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.mail.MailTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="mailTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class MailTableDaoImpl extends BaseDao implements MailTableDao {
    
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
    public List findHistory() throws SampleException {
    	return getHibernateTemplate().loadAll(MailTable.class);
    }
    
	/**
	 * 登録します。
	 * @param mailTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailTable mailTable) throws SampleException {
    	getHibernateTemplate().save(mailTable);
    }
}
