/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jtp.SampleException;
import org.jtp.entity.mail.MailAttachTable;
import org.jtp.entity.mail.MailTable;
import org.jtp.web.action.BaseDownloadAction;

/**
 * メール送信履歴画面アクションクラスです。
 * 
 * @struts.action
 *  name="mail/InputForm"
 *  path="/mail/history"
 *  scope="request"
 *  validate="true"
 *  input="/mail/history.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="detail"
 *  path="/mail/history_detail.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/mail/history.tiles"
 * @struts.action-forward
 *  name="download"
 *  path="/mail/history_detail.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/mail/history.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class HistoryAction extends BaseDownloadAction {

	/**
	 * 詳細表示アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward detail(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
    	int index = Integer.parseInt(request.getParameter("index"));
    	List list = (List) getSession(request).getAttribute("historyList");
    	MailTable entity = (MailTable) list.get(index);
    	if (StringUtils.isNotEmpty(entity.getBody())) {
        	entity.setBody(entity.getBody().replaceAll("\r\n", "<br>"));
    	}
     	request.setAttribute("mailTable", entity);
    	request.setAttribute("index", String.valueOf(index));
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * ダウンロードファイル名を取得します。
     * @param form 存在するならば、このリクエストのためのActionForm Bean
     * @param request 処理しているHTTPリクエスト
     * @return ダウンロードファイル名
     */
	@Override
    protected String getFileName(ActionForm form, HttpServletRequest request) {
        return getMailAttachTable(request).getAttachName();
	}

    /**
     * ダウンロードファイルの入力ストリームを取得します。
     * @param form 存在するならば、このリクエストのためのActionForm Bean
     * @param request 処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return ダウンロードファイルの入力ストリーム
     * @throws IOException I/O例外
     */
	@Override
    protected InputStream getDownloadStream(ActionForm form,
    		HttpServletRequest request,	HttpServletResponse response) throws IOException {
        return new ByteArrayInputStream(getMailAttachTable(request).getAttach());
    }

	/**
	 * トークン確認を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	@Override
	protected boolean isSkipTokenValid(HttpServletRequest request) {
		return "download".equals(request.getParameter(FORWARD_EVENT));
	}
	
	/**
	 * 選択された添付メールテーブルのエンティティを取得します
	 * @param request 処理しているHTTPリクエスト
	 * @return 選択された添付メールテーブルのエンティティ
	 */
	private MailAttachTable getMailAttachTable(HttpServletRequest request) {
    	int index = Integer.parseInt(request.getParameter("index"));
    	int seq = Integer.parseInt(request.getParameter("seq"));
    	List list = (List) request.getSession().getAttribute("historyList");
    	MailTable mailTable = (MailTable) list.get(index);
		Set mailAttachTables = mailTable.getMailAttachTables();
		
		MailAttachTable result = null;
        for (Iterator it = mailAttachTables.iterator(); it.hasNext();) {
        	MailAttachTable entity = (MailAttachTable) it.next();
        	if (entity.getId().getSeq().intValue() != seq) continue;
        	result = entity;
        }
        return result;
	}
}
