/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jtp.SampleException;
import org.jtp.logic.mail.MailAccountTableService;
import org.jtp.logic.mail.MailAddressTableService;
import org.jtp.logic.mail.MailTableService;
import org.jtp.web.action.BaseAction;

/**
 * ナビゲーション画面アクションクラスです。
 * 
 * @struts.action
 *  path="/mail/navigation"
 *  scope="request"
 *  validate="true"
 *  input="/mail/send.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="send"
 *  path="/mail/send.tiles"
 * @struts.action-forward
 *  name="history"
 *  path="/mail/history.tiles"
 * @struts.action-forward
 *  name="address"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="account"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/jsp/common/menu.jsp"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class NavigationAction extends BaseAction {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(NavigationAction.class);

    /** メールテーブル情報サービス */
    private MailTableService mailTableService;

    /** メールアドレステーブル情報サービス */
    private MailAddressTableService mailAddressTableService;

    /** アカウントテーブル情報サービス */
    private MailAccountTableService mailAccountTableService;

    
    /**
     * メールテーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailTableService(MailTableService mailTableService) {
		this.mailTableService = mailTableService;
	}
    
    /**
     * メールアドレステーブル情報サービスを設定します。
     * @param mailAddressTableService メールアドレステーブル情報サービス
     */
	public void setMailAddressTableService(MailAddressTableService mailAddressTableService) {
		this.mailAddressTableService = mailAddressTableService;
	}
    
    /**
     * アカウントテーブル情報サービスを設定します。
     * @param mailAccountTableService メールアドレステーブル情報サービス
     */
	public void setMailAccountTableService(MailAccountTableService mailAccountTableService) {
		this.mailAccountTableService = mailAccountTableService;
	}

    /**
     * 画面アクション
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws Exception 例外
     */
	@Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
		getSession(request).removeAttribute("accountList");
		getSession(request).removeAttribute("addressList");
		getSession(request).removeAttribute("historyList");
		return super.execute(mapping, form, request, response);
	}
	
	/**
	 * 送信アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public ActionForward send(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		getSession(request).setAttribute("accountList", mailAccountTableService.findAll());
		getSession(request).setAttribute("addressList", mailAddressTableService.findAll());
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * 送信履歴アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward history(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		List result = mailTableService.findHistory();
		_log.info("history：" + ((result == null) ? 0 : result.size()));
		getSession(request).setAttribute("historyList", result);
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * アドレス帳アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward address(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		List result = mailAddressTableService.findAll();
		getSession(request).setAttribute("addressList", result);
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }
    
    /**
     * アカウント設定アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	public ActionForward account(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		List result = mailAccountTableService.findAll();
		getSession(request).setAttribute("accountList", result);
    	return mapping.findForward(request.getParameter(FORWARD_EVENT));
    }

	/**
	 * トークン確認を行なわないかを確認します
     * @param request  処理しているHTTPリクエスト
	 * @return true[行わない]、false[行う]
	 */
	@Override
	protected boolean isSkipTokenValid(HttpServletRequest request) {
		return true;
	}
}
