/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.HashSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.DynaValidatorActionForm;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAttachTable;
import org.jtp.entity.mail.MailAttachTablePK;
import org.jtp.entity.mail.MailBccTable;
import org.jtp.entity.mail.MailBccTablePK;
import org.jtp.entity.mail.MailCcTable;
import org.jtp.entity.mail.MailCcTablePK;
import org.jtp.entity.mail.MailTable;
import org.jtp.logic.mail.MailTableService;
import org.jtp.web.action.BaseAction;
import org.jtp.web.bean.SendMailBean;

/**
 * メール送信画面アクションクラスです。
 * 
 * @struts.action
 *  name="mail/InputForm"
 *  path="/mail/send"
 *  scope="request"
 *  validate="true"
 *  input="/mail/send.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="success"
 *  path="/mail/send.tiles"
 *
 * @author <a href="mailto:sato-vista@jade.plala.or.jp">Satoshi Nagashiba</a>
 */
public class SendAction extends BaseAction {

    /** メールテーブル情報サービス */
    private MailTableService mailTableService;

    
    /**
     * メールテーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailTableService(MailTableService mailTableService) {
		this.mailTableService = mailTableService;
	}

	/**
	 * 送信アクションを処理します。
     * @param mapping  このインスタンスを選択するために使用したActionMapping
     * @param form     存在するならば、このリクエストのためのActionForm Bean
     * @param request  処理しているHTTPリクエスト
     * @param response 処理しているHTTPレスポンス
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public ActionForward send(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response) throws Exception {
		SendMailBean input = new SendMailBean();
		PropertyUtilsWrapper.copyProperties(((DynaValidatorActionForm) form).getMap(), input);
		MailTable entity = new MailTable();
		PropertyUtils.copyProperties(entity, input);
		
		if (StringUtils.isNotEmpty(input.getCc())) {
			entity.setMailCcTables(new HashSet());
			String[] args = input.getCc().trim().split(",");
			for (int i = 0; i < args.length; i++) {
				MailCcTable cc = new MailCcTable();
				cc.setId(new MailCcTablePK());
				cc.getId().setSeq(new Integer(i));
				cc.setCc(args[i]);
				entity.getMailCcTables().add(cc);
			}
		}
		
		if (StringUtils.isNotEmpty(input.getBcc())) {
			entity.setMailBccTables(new HashSet());
			String[] args = input.getBcc().trim().split(",");
			for (int i = 0; i < args.length; i++) {
				MailBccTable bcc = new MailBccTable();
				bcc.setId(new MailBccTablePK());
				bcc.getId().setSeq(new Integer(i));
				bcc.setBcc(args[i]);
				entity.getMailBccTables().add(bcc);
			}
		}
		
		FormFile[] files = (FormFile[]) ((DynaValidatorActionForm) form).get("attachment");
		for (int i = 0; i < files.length; i++) {
			if (StringUtils.isEmpty(files[i].getFileName())) continue;
			if (entity.getMailAttachTables() == null) {
				entity.setMailAttachTables(new HashSet());
			}
			MailAttachTable attach = new MailAttachTable();
			attach.setId(new MailAttachTablePK());
			attach.getId().setSeq(new Integer(i));
			attach.setAttachName(files[i].getFileName());
			attach.setAttach(files[i].getFileData());
			entity.getMailAttachTables().add(attach);
		}
		
		mailTableService.save(entity);
    	return mapping.findForward(FORWARD_SUCCESS);
    }
}
