/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.apache.struts;

import java.util.Collection;
import java.util.Iterator;
import xjavadoc.XClass;
import xjavadoc.XTag;

import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.apache.struts.ejb.XDocletModulesApacheStrutsEjbMessages;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.Translator;

/**
 * Generates a Struts ActionForm, based on a POJO. More information on Struts is available on the <a
 * href="http://struts.apache.org/">Struts website</a> , or the <a
 * href="http://struts.apache.org/api/org/apache/struts/action/ActionForm.html">ActionForm API</a>.
 *
 * @author        Matt Raible (matt@raibledesigns.com)
 * @created       April 26, 2004
 * @ant.element   display-name="Action Form" name="actionform" parent="xdoclet.DocletTask"
 * @version       $Revision: 1.1 $
 */
public class ActionFormSubTask extends TemplateSubTask
{
    /**
     * The default template file - struts_form.xdt.
     */
    protected static String DEFAULT_TEMPLATE_FILE = "resources/struts_form.xdt";

    /**
     * The pattern for the form class. Defaults to {0}{1}Form if not present.
     */
    protected String formClassPattern;

    /**
     * Form tag being processed right now.
     */
    protected XTag  currentFormTag;

    /**
     * Describe what the ActionFormActionFormSubTaskstructor does
     */
    public ActionFormSubTask()
    {
        setTemplateURL(getClass().getResource(DEFAULT_TEMPLATE_FILE));
        setDestinationFile(getActionFormClassPattern() + ".java");
        addOfType("java.lang.Object");
    }

    /**
     * Gets the CurrentFormTag attribute of the ActionFormSubTask object
     *
     * @return   The CurrentFormTag value
     */
    public XTag getCurrentFormTag()
    {
        return currentFormTag;
    }

    /**
     * Return the class pattern.
     *
     * @return   The ActionFormClassPattern value
     */
    public String getActionFormClassPattern()
    {
        if (formClassPattern != null) {
            return formClassPattern;
        }
        else {
            return "{0}{1}Form";
        }
    }

    /**
     * Sets the CurrentFormTag attribute of the ActionFormSubTask object
     *
     * @param t  The new CurrentFormTag value
     */
    public void setCurrentFormTag(XTag t)
    {
        this.currentFormTag = t;
    }

    /**
     * Sets the Pattern attribute of the ActionFormSubTask object
     *
     * @param newPattern  The new Pattern value
     */
    public void setPattern(String newPattern)
    {
        formClassPattern = newPattern;
    }

    /**
     * Called to validate configuration parameters.
     *
     * @exception XDocletException  Description of Exception
     */
    public void validateOptions() throws XDocletException
    {
        super.validateOptions();

        if (getActionFormClassPattern() == null || getActionFormClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, XDocletMessages.PARAMETER_MISSING_OR_EMPTY, new String[]{"pattern"}));
        }

        if (getActionFormClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, XDocletModulesEjbMessages.PATTERN_HAS_NO_PLACEHOLDER));
        }
        if (getActionFormClassPattern().indexOf("{1}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, XDocletModulesApacheStrutsEjbMessages.PATTERN_HAS_NO_FORM_PLACEHOLDER));
        }
    }

    /**
     * Gets the GeneratedFileName attribute of the ActionFormSubTask object
     *
     * @param clazz                 Describe what the parameter does
     * @return                      The GeneratedFileName value
     * @exception XDocletException  Describe the exception
     */
    protected String getGeneratedFileName(XClass clazz) throws XDocletException
    {
        return PackageTagsHandler.packageNameAsPathFor(ActionFormTagsHandler.getActionFormClassFor(getCurrentClass())) + ".java";
    }

    /**
     * Returns whether struts form[s] shall be generated for this class
     *
     * @param clazz                 Description of Parameter
     * @return                      is form tag shall be generated
     * @exception XDocletException  Description of Exception
     */
    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException
    {
        if (super.matchesGenerationRules(clazz) == false) {
            return false;
        }

        if (ActionFormTagsHandler.hasFormDefinition(getCurrentClass())) {
            return true;
        }
        else {
            return false;
        }
    }

    /**
     * iterate through all struts:form tags,and produce separate classes
     *
     * @param clazz                 Description of Parameter
     * @exception XDocletException  Description of Exception
     */
    protected void generateForClass(XClass clazz) throws XDocletException
    {
        Collection formTags = clazz.getDoc().getTags("struts.form");

        for (Iterator i = formTags.iterator(); i.hasNext(); ) {
            XTag tag = (XTag) i.next();

            setCurrentFormTag(tag);
            super.generateForClass(clazz);
        }
    }

    /**
     * Describe what the method does
     *
     * @exception XDocletException  Describe the exception
     */
    protected void engineStarted() throws XDocletException
    {
        System.out.println(Translator.getString(XDocletModulesApacheStrutsEjbMessages.class, XDocletModulesApacheStrutsEjbMessages.GENERATING_FILE,
            new String[]{ActionFormTagsHandler.getActionFormClassName(getCurrentClass())}));
    }
}
