/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* mkbingram --- make binary n-gram for JULIUS from ARPA standard format */

/* $Id: mkbingram.c,v 1.4 2004/03/22 04:14:32 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/ngram2.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h>

NGRAM_INFO ngram;

void
usage(char *s)
{
  j_printerr("mkbingram: make binary n-gram from ARPA format for Julius\n");
  j_printerr("usage: %s [ARPA 2-gram] [ARPA rev-3-gram] outfile\n", s);
  exit(1);
}


int
main(int argc, char *argv[])
{
  FILE *fp;
  char header[512];
  time_t now;

  if (argc != 4) usage(argv[0]);
  printf("    2-gram: %s\n", argv[1]);
  printf("rev-3-gram: %s\n", argv[2]);

  /* make header string */
  now = time(NULL);
  sprintf(header, "converted at %sfrom     2-gram = %s\n     rev-3-gram = %s\n", ctime(&now),  argv[1], argv[2]);
  
  /* read in ARPA n-gram */
  init_ngram_arpa(&ngram, argv[1], argv[2]);
  print_ngram_info(&ngram);

  /* write in JULIUS binary format */
  if ((fp = fopen(argv[3], "wb+")) == NULL) {
    j_printerr("failed to open %s\n", argv[3]);
    return -1;
  }
  printf("Writing to %s...\n", argv[3]);
  if (ngram_write_bin(fp, &ngram, header) == FALSE){/* failed */
    j_printerr("failed to write %s\n",argv[3]);
    return -1;
  }
  fclose(fp);
  printf("completed\n");
  
  return 0;
}
