/*
 * Copyright (c) 2002-2004 NAIST
 * All rights reserved
 */

#ifndef __JAPI_H__
#define __JAPI_H__

#define DEFAULT_PORT 10500	/* default server port number */

#define MAXLINELEN 4096

/* server.c */
int do_connect(char *hostname, int portnum);
void do_disconnect(int sd);
void do_sendf(int sd, char *fmt, ...);
void do_send(int sd, char *buf);
char *do_receive(int sd, char *buf, int maxlen);

/* japi_misc.c */
void japi_die(int);
void japi_get_version(int);
void japi_get_status(int);
void japi_pause_recog(int);
void japi_terminate_recog(int);
void japi_resume_recog(int);
void japi_set_input_handler_on_change(int, char *);

/* japi_grammar.c */
void japi_change_grammar(int sd, char *prefixpath);
void japi_add_grammar(int sd, char *prefixpath);
void japi_delete_grammar(int sd, char *idlist);
void japi_activate_grammar(int sd, char *idlist);
void japi_deactivate_grammar(int sd, char *idlist);

#endif /* __JAPI_H__ */
