/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* rdhmmdef_options.c --- read in hmmdefs (global options at header) */

/* $Id: rdhmmdef_options.c,v 1.6 2004/03/22 04:14:31 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_param.h>
#include <sent/htk_hmm.h>

/* HMM options */
static OptionStr optcov[] = {	/* covariance matrix type */
  {"DIAGC", C_DIAG_C, "Diag", TRUE},
  {"INVDIAGC", C_INV_DIAG, "InvDiag", FALSE},
  {"FULLC", C_FULL, "Full", FALSE},
  {"LLTC", C_LLT, "LLT", FALSE}, /* not used in HTK V2.0 */
  {"XFORMC", C_XFORM, "Xform", FALSE},  /* not used in HTK V2.0 */
  {NULL,0,NULL,FALSE}
};
static OptionStr optdur[] = {	/* duration types */
  {"NULLD", D_NULL, "Null", TRUE},
  {"POISSOND", D_POISSON, "Poisson", FALSE},
  {"GAMMAD", D_GAMMA, "Gamma", FALSE},
  {"GEND", D_GEN, "Gen", FALSE},
  {NULL,0,NULL,FALSE}
};

/* Parameter Options are handled in paramtypes.c */

extern char *rdhmmdef_token;			/* token */


/* read in options */
static void
read_global_opt(FILE *fp, HTK_HMM_Options *op)
{
  int i;
  short tmptype;

  for (;;) {
    if (rdhmmdef_token == NULL) return;
    if (currentis("HMMSETID")) { /* <HMMSETID> */
      read_token(fp);
      NoTokErr("missing HMMSETID argument");
    } else if (currentis("STREAMINFO")) { /* <STREAMINFO> */
      read_token(fp);
      NoTokErr("missing STREAMINFO num");
      op->stream_info.num = atoi(rdhmmdef_token);
      /*DM("%d STREAMs:", op->stream_info.num);*/
      if (op->stream_info.num > 50) {
	j_printerr("stream num exceeded %d\n", 50);
	rderr(NULL);
      }
      for (i=0;i<op->stream_info.num;i++) {
	read_token(fp);
	NoTokErr("missing STREAMINFO vector size");
	op->stream_info.vsize[i] = atoi(rdhmmdef_token);
	/*DM(" %d",op->stream_info.vsize[i]);*/
      }
      /*DM("\n");*/
      
    } else if (currentis("VECSIZE")) {	/* <VECSIZE> */
      read_token(fp);
      NoTokErr("missing VECSIZE value");
      op->vec_size = atoi(rdhmmdef_token);
      /*DM("vector size: %d\n", op->vec_size);*/
      
    } else {
      /* covariance matrix type */
      for (i=0;optcov[i].name!=NULL;i++) {
	if (currentis(optcov[i].name)) {
	  op->cov_type = optcov[i].type;
	  /*DM("covariance matrix type: %s\n", optcov[i].desc);*/
	  goto optloop;
	}
      }
      /* duration type */
      for (i=0;optdur[i].name!=NULL;i++) {
	if (currentis(optdur[i].name)) {
	  op->dur_type = optdur[i].type;
	  /*DM("duration type: %s\n", optdur[i].desc);*/
	  goto optloop;
	}
      }
      /* parameter type */
      tmptype = param_str2code(rdhmmdef_token);
      if (tmptype != F_ERR_INVALID) { /* conv success */
	op->param_type = tmptype;
	/*DM("param type: %s", param_code2str(buf, op->param_type, FALSE));*/
	goto optloop;
      } else {
	/* nothing of above --- not option */
	return;
      }
    }
  optloop:
    read_token(fp);
  }
}

void
set_global_opt(FILE *fp, HTK_HMM_INFO *hmm)
{
  read_global_opt(fp,&(hmm->opt));
}


/* get HMM Option name from type code */
static char *
get_opttype_str(OptionStr *confdata, short type)
{
  int i;
  for (i = 0; confdata[i].name != NULL; i++) {
    if (confdata[i].type == type) {
      return(confdata[i].name);
    }
  }
  rderr("unknown typecode in header!");
  return(NULL);
}

char *
get_cov_str(short covtype)
{
  return(get_opttype_str(optcov, covtype));
}
char *
get_dur_str(short durtype)
{
  return(get_opttype_str(optdur, durtype));
}
