/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* gprune_none.c --- calculate probability of Gaussian densities */
/*                   no pruning  */

/* $Id: gprune_none.c,v 1.5 2004/03/22 04:14:32 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>
#include <sent/htk_param.h>
#include <sent/hmm.h>
#include <sent/gprune.h>
#include "globalvars.h"

/* calculate probability of a Gaussian density */
LOGPROB
compute_g_base(HTK_HMM_Dens *binfo)
{
  VECT tmp, x;
  VECT *mean;
  VECT *var;
  VECT *vec = OP_vec;
  short veclen = OP_veclen;

  if (binfo == NULL) return(LOG_ZERO);
  mean = binfo->mean;
  var = binfo->var->vec;
  tmp = 0.0;
  for (; veclen > 0; veclen--) {
    x = *(vec++) - *(mean++);
    tmp += x * x / *(var++);
  }
  return((tmp + binfo->gconst) / -2.0);
}

/* init */
boolean
gprune_none_init()
{
  /* maximum Gaussian set size = maximum mixture size */
  OP_calced_maxnum = OP_hmminfo->maxmixturenum;
  OP_calced_score = (LOGPROB *)mymalloc(sizeof(LOGPROB) * OP_calced_maxnum);
  OP_calced_id = (int *)mymalloc(sizeof(int) * OP_calced_maxnum);
  /* force gprune_num to the max number */
  OP_gprune_num = OP_calced_maxnum;
  return TRUE;
}

/* compute a set of Gaussians with no pruning */
void
gprune_none(HTK_HMM_Dens **g, int num, int *last_id) /* last_id ignored */
{
  int i;
  HTK_HMM_Dens *dens;
  LOGPROB *prob = OP_calced_score;
  int *id = OP_calced_id;
  OP_calced_num = 0;
  for(i=0; i<num; i++) {
    dens = *(g++);
    if (!dens) continue;	/* skip if density = NULL */
    *(prob++) = compute_g_base(dens);
    *(id++) = i;
    OP_calced_num++;
  }
}
