/*
 * Copyright (c) 2003 NAIST
 * All rights reserved
 */

/* mkbinhmm --- read in ascii hmmdefs file and write in binary format */

/* $Id: mkbinhmm.c,v 1.1 2003/12/08 03:31:17 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

HTK_HMM_INFO *hmminfo;


static void
usage(char *s)
{
  j_printerr("mkbinhmm: make binary hmmdefs for Julius from ascii hmmdefs\n");
  j_printerr("usage: %s ascii_hmmdefs binhmm\n", s);
  exit(1);
}


int
main(int argc, char *argv[])
{
  FILE *fp;

  if (argc != 3) usage(argv[0]);

  hmminfo = hmminfo_new();

  j_printf("---- reading ----\n");
  j_printf("filename: %s\n", argv[1]);

  /* read ascii hmmdef file */
  j_printerr("reading HMM definition...");
  if ((fp = fopen_readfile(argv[1])) == NULL) {
    j_error("failed to open %s\n", argv[1]);
  }
  if (rdhmmdef(fp, hmminfo) == FALSE) {
    j_error("failed to read %s\n", argv[1]);
  }
  if (fclose_readfile(fp) < 0) {
    j_error("failed to close %s\n", argv[1]);
  }

  j_printf("\n");
  print_hmmdef_info(hmminfo);
  j_printf("\n");

  j_printf("---- writing ----\n");
  j_printf("filename: %s\n", argv[2]);
  
  if ((fp = fopen(argv[2], "w")) == NULL) {
    j_error("failed to open %s for writing\n", argv[2]);
  }
  if (write_binhmm(fp, hmminfo) == FALSE) {
    j_error("failed to write to %s\n", argv[2]);
  }
  if (fclose(fp) != 0) {
    j_error("failed to close %s\n", argv[2]);
  }

  j_printf("\n");
  j_printf("binary HMM written to \"%s\"\n", argv[2]);

  return 0;
}
