/**
 * @file   m_adin.c
 * @author Akinobu LEE
 * @date   Fri Mar 18 16:17:23 2005
 * 
 * <JA>
 * @brief  ϥǥХν
 * </JA>
 * 
 * <EN>
 * @brief  Initialize audio input device
 * </EN>
 * 
 * $Revision:$
 * 
 */
/*
 * Copyright (c) 1991-2005 Kawahara Lab., Kyoto University
 * Copyright (c) 2000-2005 Shikano Lab., Nara Institute of Science and Technology
 * Copyright (c) 2005      Julius project team, Nagoya Institute of Technology
 * All rights reserved
 */

#include <julius.h>

/** 
 * <JA>
 * ϥǥХ롥speech_input 򤵤ƤǥХ
 * ץ󥰼ȿ䲻ѥѥ᡼򥻥åȤ롥
 * 
 * </JA>
 * <EN>
 * Initialize audio input device specified by speech_input, and set
 * parameters for sampling rate and speech detection parameters.
 * 
 * </EN>
 */
void
adin_initialize()
{
  char *arg = NULL;
  boolean igsp = TRUE;

  if (speech_input == SP_MFCFILE) return; /* no need to initialize */
  
  VERMES("###### initialize input device\n");

  /* select input device: file, mic, netaudio, etc... */
  if (adin_select(speech_input) == FALSE) {
    j_error("Error: invalid input device\n");
  }

  /* set sampling frequency and device-dependent configuration
     (argument is device-dependent) */
  switch(speech_input) {
  case SP_ADINNET:		/* arg: port number */
    arg = mymalloc(100);
    sprintf(arg, "%d", adinnet_port);
    break;
  case SP_RAWFILE:		/* arg: filename of file list (if any) */
    if (inputlist_filename != NULL) {
      arg = mymalloc(strlen(inputlist_filename)+1);
      strcpy(arg, inputlist_filename);
    } else {
      arg = NULL;
    }
    break;
  case SP_STDIN:
    arg = NULL;
    break;
#ifdef USE_NETAUDIO
  case SP_NETAUDIO:		/* netaudio server/port name */
    arg = mymalloc(strlen(netaudio_devname)+1);
    strcpy(arg, netaudio_devname);
    break;
#endif
  }

  if (speech_input == SP_MIC) {
#ifdef SP_BREAK_CURRENT_FRAME
    igsp = FALSE;		/* does not drop speech while decoding */
#endif
  }
  
  if (adin_standby(smpFreq, arg) == FALSE) { /* fail */
    j_error("Error: failed to ready input device\n");
  }

  /* set parameter for recording/silence detection */
  adin_setup_param(silence_cut,/* silence cutting: 0=off,1=on,2=use device default */
		   strip_zero_sample, /* strip zero sample if TRUE */
		   level_thres,	/* trigger level threshold (0-32767) */
		   zero_cross_num, /* zero-cross num for silence detection */
		   head_margin_msec, /* margin at beginning of input segment */
		   tail_margin_msec, /* margin at end of input segment */
		   smpFreq,	/* sampling frequency */
		   igsp,	/* TRUE if ignore speech while decoding */
		   use_zmean);	/* TRUE if need zmeansource */

  if (arg != NULL) free(arg);
}
