/**
 * @file   mkcpair.c
 * @author Akinobu LEE
 * @date   Tue Feb 15 14:35:33 2005
 * 
 * <JA>
 * @brief  ʸˡ饫ƥФ
 *
 * DFAʸˡ顤ǧ裱ѥѤ륫ƥ֤³Фޤ
 * Фƥоʸˡǡ˳Ǽޤ
 *
 * 硼ȥݡñ줬ʸˡǻꤵƤ硤³Ϥ
 * 硼ȥݡñΥåפθФޤ
 * 
 * ʤǤϽ¤顤Υåײǽʥ硼ȥݡñ줬
 * ʸƬʸ˽и뤳ȤϵƤޤ
 * ϳϡü̵ʬˤñϡsilB, silE ʤ
 * Υåײǽʥ硼ȥݡʳñƤ褦ˤƤ
 * </JA>
 * 
 * <EN>
 * @brief  Extract category-pair constraint from DFA grammar
 *
 * These functions extract whether the each grammar category can be connected
 * or not in the given DFA grammar, and store the extracted data to the DFA
 * grammar information.  This category-pair constraint will be used at the
 * first pass of recognition as a degenerated linguistic constraint.
 *
 * If a short pause word is defined in the grammar, the connection constraint
 * will be extracted considering the skipping of this pause model, since the
 * pause word may not appear on the specified location in the actual utterance.
 *
 * Please note that a grammar rule that allows such skippable short-pause word
 * to appear at the beginning and end of sentence is prohibited.  Instead,
 * you should use another (non-skippable) silence word like "sil" as the
 * beginning and ending of sentence to match the head and tail silence.
 * 
 * </EN>
 * 
 * $Revision:$
 * 
 */
/*
 * Copyright (c) 1991-2005 Kawahara Lab., Kyoto University
 * Copyright (c) 2000-2005 Shikano Lab., Nara Institute of Science and Technology
 * Copyright (c) 2005      Julius project team, Nagoya Institute of Technology
 * All rights reserved
 */

#include <sent/stddefs.h>
#include <sent/dfa.h>

/** 
 * Extract category-pair constraint from DFA grammar and newly set the category
 * pair matrix of the give DFA.
 * 
 * @param dinfo [i/o] DFA grammar, in which the category-pair matrix will be created.
 */
void
extract_cpair(DFA_INFO *dinfo)
{
  int i;
  DFA_ARC *arc_l, *arc_r, *arc_r2;
  int left, right;

  /* initialize */
  malloc_dfa_cp(dinfo, dinfo->term_num);

  /* extract cpair info */
  for (i=0;i<dinfo->state_num;i++) {
    if ((dinfo->st[i].status & INITIAL_S) != 0) { /* arc from initial state */
      for (arc_r = dinfo->st[i].arc; arc_r; arc_r = arc_r->next) {
	if (dinfo->is_sp[arc_r->label]) {
	  j_error("Error: skippable sp should not appear at end of sentence\n");
	}
	set_dfa_cp_end(dinfo, arc_r->label, TRUE);
      }
    }
    for(arc_l = dinfo->st[i].arc; arc_l; arc_l = arc_l->next) {
      left = arc_l->label;
      if ((dinfo->st[arc_l->to_state].status & ACCEPT_S) != 0) {/* arc to accept state */
	if (dinfo->is_sp[left]) {
	  j_error("Error: skippable sp should not appear at beginning of sentence\n");
	}
	set_dfa_cp_begin(dinfo, left, TRUE);
      }
      /* others */
      for (arc_r = dinfo->st[arc_l->to_state].arc; arc_r; arc_r = arc_r->next) {
	right = arc_r->label;
	set_dfa_cp(dinfo, right, left, TRUE);
	if (dinfo->is_sp[right]) {
	  for (arc_r2 = dinfo->st[arc_r->to_state].arc; arc_r2; arc_r2 = arc_r2->next) {
	    if (dinfo->is_sp[arc_r2->label]) { /* sp model continues twice */
	      j_error("Error: skippable sp should not repeat\n");
	    }
	    set_dfa_cp(dinfo, arc_r2->label, left, TRUE);
	  }
	}
      }

    }
  }
}

/** 
 * Append the category pair matrix at the last.
 * 
 * @param dst [i/o] DFA grammar
 * @param src [in] DFA grammar to be appended to @a dst
 * @param coffset [in] category id in @a dst where the new data should be stored
 */
void
cpair_append(DFA_INFO *dst, DFA_INFO *src, int coffset)
{
  int i,j;

  /* dst info must be already appended */
  /* [coffset..dst->term_num-1] is the new categories */
  if (dst->term_num - coffset != src->term_num) {
    j_error("InternalError: append term num not match!: %d, %d, %d\n",
	    dst->term_num, src->term_num, coffset);
  }

  /* allocate appended area */
  realloc_dfa_cp(dst, coffset, dst->term_num);
  
  /* append cp */
  for(i=coffset;i<dst->term_num;i++) {
    for(j=coffset;j<dst->term_num;j++) {
      set_dfa_cp(dst, i, j, dfa_cp(src, i-coffset, j-coffset));
    }
    set_dfa_cp_begin(dst, i, dfa_cp_begin(src, i-coffset));
    set_dfa_cp_end(dst, i, dfa_cp_end(src, i-coffset));
  }
}
