/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* wrsamp.c --- write waveform to file descpriter */

/* $Id: wrsamp.c,v 1.3 2002/11/07 15:52:10 ri Exp $ */

/* output endian is formatted to BIG ENDIAN */

#include <sent/stddefs.h>
#include <sent/speech.h>

int
wrsamp(int fd, SP16 *buf, int len)
{
  int ret;
#ifndef WORDS_BIGENDIAN
  /* swap byte order to BIG ENDIAN */
  swap_sample_bytes(buf, len);
#endif
  ret = write(fd, buf, len * sizeof(SP16));
#ifndef WORDS_BIGENDIAN
  /* undo byte swap */
  swap_sample_bytes(buf, len);
#endif
  return(ret);
}
