/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* voca_util.c -- voabulary (dictionary) related utility functions */

/* $Id: voca_util.c,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/vocabulary.h>

/* output vocabulary info */
void
print_voca_info(WORD_INFO *winfo)
{
  int i,j;
  long models, states;
  int trnum;
  HMM_Logical *lg;

  models = 0;
  states = 0;
  trnum = 0;
  for (i=0;i<winfo->num;i++) {
    models += winfo->wlen[i];
    for (j=0;j<winfo->wlen[i];j++) {
      lg = winfo->wseq[i][j];
      states += hmm_logical_state_num(lg) - 2;
    }
    if (winfo->is_transparent[i]) trnum++;
  }

  j_printf("Dictionary Info:\n");
  /*j_printf("        vocabulary size  = %d words, %d models, %d states\n", winfo->num, models, states);*/
  j_printf("        vocabulary size  = %d words, %d models\n", winfo->num, models);
  j_printf("        average word len = %.1f models, %.1f states\n", (float)models/(float)winfo->num, (float)states/(float)winfo->num);
  j_printf("       maximum state num = %d nodes per word\n", winfo->maxwn);
  j_printf("       transparent words = %d words\n", trnum);
}
	 
/* output voca info string */
void
put_voca(WORD_INFO *winfo, WORD_ID wid)
{
  int i;
  HMM_Logical *lg;
  
  j_printf("%d: %s", wid, winfo->wname[wid]);
  if (winfo->is_transparent) {
    j_printf(" {%s}", winfo->woutput[wid]);
  } else {
    j_printf(" [%s]", winfo->woutput[wid]);
  }
  for(i=0;i<winfo->wlen[wid];i++) {
    lg = winfo->wseq[wid][i];
    j_printf(" %s", lg->name);
    if (lg->is_pseudo) {
      j_printf("(pseudo)");
    } else {
      j_printf("(%s)", lg->body.defined->name);
    }
  }
  j_printf("\n");
}
void
put_voca_err(WORD_INFO *winfo, WORD_ID wid)
{
  int i;
  HMM_Logical *lg;
  
  j_printerr("id%d: %s", wid, winfo->wname[wid]);
  if (winfo->is_transparent) {
    j_printerr(" {%s}", winfo->woutput[wid]);
  } else {
    j_printerr(" [%s]", winfo->woutput[wid]);
  }
  for(i=0;i<winfo->wlen[wid];i++) {
    lg = winfo->wseq[wid][i];
    j_printerr(" %s", lg->name);
    if (lg->is_pseudo) {
      j_printerr("(pseudo)");
    } else {
      j_printerr("(%s)", lg->body.defined->name);
    }
  }
  j_printerr("\n");
}
