/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* init_voca.c --- read in dict file */

/* $Id: init_voca.c,v 1.5 2003/10/02 01:44:53 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>
#include <sent/vocabulary.h>

/* read & initialize dictonary */
boolean
init_voca(WORD_INFO *winfo, char *filename, HTK_HMM_INFO *hmminfo, boolean not_conv_tri, boolean force_dict)
{
  FILE *fd;

  j_printerr("Reading in dictionary...\n");
  if ((fd = fopen_readfile(filename)) == NULL) {
    j_printerr("failed to open %s\n",filename);
    return(FALSE);
  }
  if (!voca_load_htkdict(fd, winfo, hmminfo, not_conv_tri)) {
    if (force_dict) {
      j_printerr("errors are ignored\n");
    } else {
      j_printerr("error in reading %s: %d words failed out of %d words\n",filename, winfo->errnum, winfo->num);
      fclose_readfile(fd);
      return(FALSE);
    }
  }
  if (fclose_readfile(fd) == -1) {
    j_printerr("close error\n");
    return(FALSE);
  }

  j_printerr("%d words...done\n", winfo->num);
  return(TRUE);
}
