/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* search.h --- data structure for 2nd pass */

/* $Id: search.h,v 1.6 2003/12/11 07:32:43 ri Exp $ */

#ifndef __SENT_SEARCH_H__
#define __SENT_SEARCH_H__

/* $B<!C18l8uJd(B */
/* predicted word */
typedef struct __nextword__ {
  WORD_ID id;			/* word ID */
#ifdef USE_NGRAM
  LOGPROB lscore;		/* N-gram score for given context */
#else  /* USE_DFA */
  int next_state;		/* next DFA state ID */
  boolean can_insert_sp;	/* TRUE if short pause can insert between source hypothesis and this word */
#endif
  TRELLIS_ATOM *tre;		/* pointer to trellis word corresponding to this word */
} NEXTWORD;

#ifdef VISUALIZE
/* store popped hypo info here (unlike NODE, this data are linked) */
typedef struct __popnode__ {
  TRELLIS_ATOM *tre;		/* last referred trellis word */
  LOGPROB score;		/* total score (g(x)+h(x)) */
  struct __popnode__ *last;	/* link to previous word context */
  struct __popnode__ *next;	/* list pointer to next structure */
} POPNODE;
#endif /* VISUALIZE */

/* $BItJ,J82>@b(B */
/* sentence hypothesis */
typedef struct __node__ {
  struct __node__    *next;	/* pointer to next hypothesis in stack */
  struct __node__    *prev;	/* pointer to last hypothesis in stack */
  boolean endflag;              /* TRUE if this hypo. already reached to final result */
  WORD_ID seq[MAXSEQNUM];	/* word sequence */
  short seqnum;                 /* length of above */
  LOGPROB score;		/* total score (forward+backward, LM+AM) */
  short bestt;                  /* last word in word trellis is best connected on this time frame */
  short estimated_next_t;	/* estimated next connection time frame (= beginning of last word on word trellis): next word hypothesis will be looked up near this frame on word trellis */
  LOGPROB *g;			/* current (forward) viterbi score in each frame */
#ifdef USE_DFA
  int state;			/* current DFA state ID */
#endif
  TRELLIS_ATOM *tre;		/* trellis word of last word */
  
  /* for context-dependency, the last phone on previous word need to be
     re-scanned, as the context varies according to the last word */
#ifndef PASS2_STRICT_IWCD
  LOGPROB *g_prev;		/* viterbi score on 1 phoneme before connection point */
#endif
  HMM_Logical *last_ph;		/* the last triphone of a hypo */
#ifdef USE_NGRAM
# ifndef PASS2_STRICT_IWCD
  LOGPROB lscore;		/* N-gram score of last word */
				/* (will be used for 1-phoneme backscan */
# endif
  LOGPROB totallscore;		/* accumulated language score (LM only) */
#endif /* USE_NGRAM */
#ifdef CONFIDENCE_MEASURE
#ifdef CM_MULTIPLE_ALPHA
  LOGPROB cmscore[MAXSEQNUM][100]; /* hold CM score of each word (multiple) */
#else
  LOGPROB cmscore[MAXSEQNUM];	/* hold CM score of each word */
#endif /* CM_MULTIPLE_ALPHA */
#endif /* CONFIDENCE_MEASURE */
#ifdef VISUALIZE
  POPNODE *popnode;		/* pointer to popped node info */
#endif
} NODE;

/*
  HOW SCORES ARE CALCULATED:
  
              0         bestt                            T-1
              |-h(n)---->|<------------g(n)--------------|
==============================================================
              |\                                         |
	      .....                                  .....  
                                                            <word trellis>
              |    \estimated_next_t                     |  =backward trellis
--------------------\------------------------------------|  (1st pass)
              |      \                                   |   
seq[seqnum-1] |       \_                                 |   
              |         \bestt                           |   
=========================+====================================================
              |           \                              |<-g[0..T-1]
              |            \                             |   
seq[seqnum-2] |             \__                          |
              |                \                         |
--------------------------------\------------------------|
     (last_ph)|                  \__                     |
              |_ _ _ _ _ _ _ _ _ _ _\ _ _ _ _ _ _ _ _ _ _|
seq[seqnum-3] |                      \______             |<--g_prev[0..T-1]
              |                             \___         |  
              |                                 \        |  
-------------------------------------------------\-------|  <forward trellis>
              ......                                ......  (2nd pass)

              |                                        \_|
===============================================================	      
*/

#endif /* __SENT_SEARCH_H__ */
