/*
 * Copyright (c) 1991-2003 Kyoto University
 * Copyright (c) 2000-2003 NAIST
 * All rights reserved
 */

/* zmean.c --- subtract zero mean from speech sample */

/* $Id: zmean.c,v 1.6 2004/01/08 09:07:34 ri Exp $ */

/* same as ZMEANSOURCE in HTK */

#include <sent/adin.h>

static int zlen = 0;		/* current recorded length */
static float zmean = 0.0;	/* current mean */

/* reset zmean count */
void
zmean_reset()
{
  zlen = 0;
  zmean = 0.0;
}

/* subtract zmean */
/* mean will be computed:
   for entire input (file input), or
   the first ZMEANSAMPLES samples (microphone/network) */
void
sub_zmean(SP16 *speech, int samplenum)
{
  int i;
  float d, sum;

  if (zlen < ZMEANSAMPLES) {
    /* update zmean */
    sum = zmean * zlen;
    for (i=0;i<samplenum;i++) {
      sum += speech[i];
    }
    zlen += samplenum;
    zmean = sum / (float)zlen;
  }
  for (i=0;i<samplenum;i++) {
    d = (float)speech[i] - zmean;
    /* clip overflow */
    if (d < -32768.0) d = -32768.0;
    if (d > 32767.0) d = 32767.0;
    /* round to SP16 (normally short) */
    if (d > 0) speech[i] = (SP16)(d + 0.5);
    else speech[i] = (SP16)(d - 0.5);
  }
}
