package org.junitdoc.core.util;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.core.rewriter.ASTUtils;

public class JavaModelUtils {

	public static boolean isMarkedAnnotationWith(String annotation,
			IMember member, CompilationUnit ast) {

		ASTNode found = findASTNode(member, ast);

		if (found == null) {
			return false;
		}

		if (found instanceof BodyDeclaration) {
			BodyDeclaration body = (BodyDeclaration) found;

			return ASTUtils.isAnnotated(body, annotation);
		}
		return false;
	}

	public static MethodDeclaration findMethodDeclaration(IMethod method,
			CompilationUnit ast) {
		ASTNode found = findASTNode(method, ast);
		if (found instanceof MethodDeclaration) {
			return (MethodDeclaration) found;
		}
		return null;
	}

	public static AnnotationTypeDeclaration findAnnotationTypeDeclaration(
			IType type, CompilationUnit ast) {

		ASTNode found = findASTNode(type, ast);
		if (found instanceof AnnotationTypeDeclaration) {
			return (AnnotationTypeDeclaration) found;
		}
		return null;
	}

	public static TypeDeclaration findTypeDeclaration(IType type,
			CompilationUnit ast) {

		ASTNode found = findASTNode(type, ast);
		if (found instanceof TypeDeclaration) {
			return (TypeDeclaration) found;
		}
		return null;
	}

	public static ASTNode findASTNode(IMember member, CompilationUnit ast) {

		if (!member.exists()) {
			return null;
		}

		try {

			final int offset = member.getNameRange().getOffset();
			final int length = member.getNameRange().getLength();

			final ASTNode[] found = new ASTNode[1];

			ast.accept(new ASTVisitor() {

				@Override
				public boolean visit(MethodDeclaration node) {
					return findMethod(node);
				}

				private boolean findMethod(MethodDeclaration node) {
					if (found[0] != null) {
						return false;
					}
					if (match(node.getName())) {
						found[0] = node;
						return false;
					}
					return true;
				}

				@Override
				public boolean visit(AnnotationTypeDeclaration node) {
					return findType(node);
				}

				@Override
				public boolean visit(TypeDeclaration node) {
					return findType(node);
				}

				private boolean findType(AbstractTypeDeclaration typeDeclare) {
					if (found[0] != null) {
						return false;
					}
					if (match(typeDeclare.getName())) {
						found[0] = typeDeclare;
						return false;
					}
					return true;
				}

				private boolean match(ASTNode node) {
					return node.getStartPosition() == offset
							&& node.getLength() == length;
				}
			});

			if (found[0] != null) {
				return found[0];
			}

		} catch (JavaModelException e) {
			JUnitDocPlugin.errorLog(e);
		}

		return null;
	}

}
