package org.junitdoc.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.junitdoc.JUnitDocPlugin;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	private static final String VM_PATH = "org/junitdoc/ui/decisiontable/decisiontable.vm.html";

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = JUnitDocPlugin.getDefault()
				.getPreferenceStore();
		store.setDefault(PreferenceConstants.P_BOOLEAN, true);
		store.setDefault(PreferenceConstants.P_CHOICE, "choice2");
		store.setDefault(PreferenceConstants.P_MAINJAVA, "src/main/java");
		store.setDefault(PreferenceConstants.P_TESTJAVA, "src/test/java");

		store.setDefault(PreferenceConstants.DECISION_TABLE_CHECK_LABEL, "Y");
		store.setDefault(PreferenceConstants.DECISION_TABLE_UNCHECK_LABEL, "");
		store
				.setDefault(
						PreferenceConstants.DECISION_TABLE_CONDITION_LABEL,
						PreferencesMessages
								.getString("preference.appearance.decisiontable.condition.label.default"));
		store
				.setDefault(
						PreferenceConstants.DECISION_TABLE_ACTION_LABEL,
						PreferencesMessages
								.getString("preference.appearance.decisiontable.action.label.default"));
		store.setDefault(PreferenceConstants.IS_LINK_WITH_EDITOR, true);
		
		URL url = JUnitDocPlugin.getDefault().getBundle().getResource(VM_PATH);
		InputStream is = null;
		try {
			is = url.openStream();
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					is, "UTF-8"));

			StringBuilder sb = new StringBuilder();

			String line;
			while ((line = reader.readLine()) != null) {
				sb.append(line);
				sb.append("\n");
			}
			store.setDefault(PreferenceConstants.DECISION_TABLE_TEMPLATE, sb.toString());
		} catch (IOException e) {
			JUnitDocPlugin.errorLog(e);

		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException ignore) {
				}
			}
		}

		store.setDefault(PreferenceConstants.P_TESTJAVA_PATTERN,
				"${package}/${type}Test.java");
	}
}
