package org.junitdoc.ui.decisiontable;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.preferences.PreferenceConstants;
import org.junitdoc.preferences.PreferenceUtils;

public class ResourceUtils {

	public static String getProjectName(IResource resource) {
		return resource.getProject().getName();
	}

	public static IFile[] findTestCases(final IFile file) {
		IFolder base = getTestJavaFolder(file.getProject());

		final List<IFile> testCases = new ArrayList<IFile>();
		try {
			base.accept(new IResourceVisitor() {

				public boolean visit(IResource resource) throws CoreException {
					if (resource instanceof IFile
							&& resource.getName().equals(
									file.getName()
											.replace(".java", "Test.java"))) {
						testCases.add((IFile) resource);
					}
					return true;
				}

			});
		} catch (CoreException e) {
			JUnitDocPlugin.errorLog(e);
		}
		return testCases.toArray(new IFile[testCases.size()]);
	}

	public static IFolder getTestJavaFolder(IProject project) {
		return project.getFolder(PreferenceUtils
				.getString(PreferenceConstants.P_TESTJAVA));
	}

	public static IFolder getMainJavaFolder(IProject project) {
		return project.getFolder(getMainJavaPath(project));
	}

	public static IPath getTestJavaPath(IProject project) {
		return new Path("/" + project.getName() + "/"
				+ PreferenceUtils.getString(PreferenceConstants.P_TESTJAVA));
	}

	public static IPath getMainJavaPath(IProject project) {
		return new Path("/" + project.getName() + "/"
				+ PreferenceUtils.getString(PreferenceConstants.P_MAINJAVA));
	}
}
