/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.common.reflect;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.stormcat.jvbeans.common.lang.StringUtil;
import org.stormcat.jvbeans.common.reflect.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageUtil {
    protected PackageUtil() {
    }

    public static List<Class<?>> getClassList(String packageName) {
        if (StringUtil.isBlank((String)packageName)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u304c\u7a7a\u3067\u3059\u3002");
        }
        String dirName = packageName.replace(".", "/");
        ArrayList classList = new ArrayList();
        URL url = Thread.currentThread().getContextClassLoader().getResource(dirName);
        if (url == null) {
            return classList;
        }
        File packageDir = new File(url.getFile());
        if (packageDir.exists()) {
            File[] fileArray = packageDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    classList.addAll(PackageUtil.getClassList(String.format("%s/%s", dirName, f.getName())));
                } else if (f.getName().endsWith(".class") && !f.getName().contains("$")) {
                    classList.add(PackageUtil.createClass(dirName, f.getName()));
                }
                ++n2;
            }
        }
        return classList;
    }

    public static List<Class<?>> getClassList(JarFile jarFile, String packageName) {
        Enumeration<JarEntry> e = jarFile.entries();
        String rootDir = packageName.replace(".", "/");
        ArrayList classList = new ArrayList();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String fullName = entry.getName();
            if (!fullName.startsWith(rootDir) || !fullName.endsWith(".class")) continue;
            classList.add(ClassUtil.forName(fullName.substring(0, fullName.length() - 6).replace("/", ".")));
        }
        return classList;
    }

    private static Class<?> createClass(String dirName, String className) {
        String fqdn = String.format("%s.%s", dirName.replace("/", "."), className.substring(0, className.length() - 6));
        return ClassUtil.forName(fqdn);
    }
}

