/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink;

import java.util.Iterator;
import org.stormcat.jvbeans.common.constants.FileExtension;
import org.stormcat.jvbeans.config.condition.OpenCondition;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.JvDataIterator;
import org.stormcat.jvbeans.jvlink.JvLinkManagerImpl;
import org.stormcat.jvbeans.jvlink.JvReader;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.jvlink.converter.JvDataConverter;
import org.stormcat.jvbeans.jvlink.converter.JvDataConverterFactory;
import org.stormcat.jvbeans.response.JvContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvSimpleReader<T extends JvBindingDto>
implements JvReader<String> {
    private JvDataIterator<T> iterator;
    private FileExtension outputType;
    private JvBeansContainer jvBeansContainer;

    public JvSimpleReader(JvLinkManagerImpl jvLinkManager, OpenCondition<T> condition) {
        this.iterator = new JvDataIterator<T>(jvLinkManager, condition);
        this.jvBeansContainer = jvLinkManager.getJvBeansContainer();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return JvSimpleReader.this.iterator.hasNext();
            }

            @Override
            public String next() {
                Object contents = JvSimpleReader.this.iterator.next();
                JvDataConverter convertor = JvDataConverterFactory.createConvertor(JvSimpleReader.this.outputType);
                ((JvContents)contents).setLine(convertor.convert(JvSimpleReader.this.jvBeansContainer, ((JvContents)contents).getLine()));
                return ((JvContents)contents).getLine();
            }

            @Override
            public void remove() {
                JvSimpleReader.this.iterator.remove();
            }
        };
    }

    @Override
    public void setOutputType(FileExtension outputType) {
        this.outputType = outputType;
    }

    @Override
    public FileExtension getOutputType() {
        return this.outputType;
    }
}

