/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze;

import java.util.Date;
import org.stormcat.jvbeans.common.lang.DateUtil;
import org.stormcat.jvbeans.common.lang.DoubleUtil;
import org.stormcat.jvbeans.common.lang.FloatUtil;
import org.stormcat.jvbeans.common.lang.IntegerUtil;
import org.stormcat.jvbeans.common.lang.LongUtil;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.util.PairValueEnumUtil;

public class JvBindingObjectConverter {
    private JvBindingObjectConverter() {
    }

    public static Object convert(String target, JvRecordMeta meta) {
        Class<?> type = meta.getType();
        float correction = meta.getCorrection();
        if (PairValueEnumUtil.isImplementsPairValueEnum(type)) {
            return PairValueEnumUtil.getPairValueEnum(type, target);
        }
        if (String.class == type) {
            return target;
        }
        if (Integer.class == type) {
            Integer i = IntegerUtil.convert(target);
            if (i == null) {
                return i;
            }
            return (int)((float)i.intValue() * correction);
        }
        if (Float.class == type) {
            Float f = FloatUtil.convert(target);
            if (f == null) {
                return f;
            }
            return Float.valueOf(f.floatValue() * correction);
        }
        if (Long.class == type) {
            Long l = LongUtil.convert(target);
            if (l == null) {
                return l;
            }
            return (long)((float)l.longValue() * correction);
        }
        if (Double.class == type) {
            Double d = DoubleUtil.convert(target);
            if (d == null) {
                return d;
            }
            return d * (double)correction;
        }
        if (Date.class == type) {
            return DateUtil.parseDate(target, "yyyyMMdd");
        }
        return null;
    }
}

