/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze.binder;

import java.util.HashMap;
import java.util.Map;
import org.stormcat.jvbeans.common.constants.FileExtension;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvCsvDataBinder;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvDataBinder;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvStandardDataBinder;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvTsvDataBinder;

public class JvDataBinderFactory {
    private static final Map<FileExtension, JvDataBinder> binderMap = new HashMap<FileExtension, JvDataBinder>();
    private static final JvStandardDataBinder standardDataBinder = new JvStandardDataBinder();

    static {
        binderMap.put(FileExtension.CSV, new JvCsvDataBinder());
        binderMap.put(FileExtension.TSV, new JvTsvDataBinder());
    }

    public static JvDataBinder createBinder(FileExtension inputType) {
        return binderMap.containsKey(inputType) ? binderMap.get(inputType) : standardDataBinder;
    }
}

