/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.converter;

import java.util.HashMap;
import java.util.Map;
import org.stormcat.jvbeans.common.constants.FileExtension;
import org.stormcat.jvbeans.jvlink.converter.JvCsvDataConverter;
import org.stormcat.jvbeans.jvlink.converter.JvDataConverter;
import org.stormcat.jvbeans.jvlink.converter.JvPlainDataConverter;
import org.stormcat.jvbeans.jvlink.converter.JvTsvDataConverter;

public class JvDataConverterFactory {
    private static final Map<FileExtension, JvDataConverter> convertorMap = new HashMap<FileExtension, JvDataConverter>();
    private static final JvPlainDataConverter plainDataConvertor = new JvPlainDataConverter();

    static {
        convertorMap.put(FileExtension.CSV, new JvCsvDataConverter());
        convertorMap.put(FileExtension.TSV, new JvTsvDataConverter());
    }

    public static JvDataConverter createConvertor(FileExtension outputType) {
        return convertorMap.containsKey(outputType) ? convertorMap.get(outputType) : plainDataConvertor;
    }
}

