/* $Id: MessageBox.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    MessageBox.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;

public class MessageBox {
    private ArrayList m_messages = new ArrayList();
    private boolean   m_available = false;

    public synchronized SECSMessage get() {
        while (m_available == false) {
            try {
                wait();
            } catch (InterruptedException e) { }
        }
        SECSMessage msg = (SECSMessage)m_messages.remove(0);  // Get first
        m_available = false;
        notifyAll();
        return msg;
    }

    public synchronized SECSMessage get(int sec) {
        while (m_available == false) {
            try {
                wait(sec * 1000);
            } catch (InterruptedException e) { }
        }
        SECSMessage msg = (SECSMessage)m_messages.remove(0);  // Get first
        m_available = false;
        notifyAll();
        return msg;
    }

    public synchronized void put(SECSMessage msg) {
        while (m_available == true) {
            try {
                wait();
            } catch (InterruptedException e) { }
        }
        m_messages.add(msg);
        m_available = true;
        notifyAll();
    }
}
