/* $Id: SECS2XML.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECS2XML.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.lang.*;
import java.util.*;

public class SECS2XML implements SECSParser {
    StringBuffer xml = new StringBuffer();
    int    currentNest = 1;
    int    listSize;
    int    listPos;
    SECSMessage message;

    // Constractor
    public SECS2XML() { }

    // Dump object
    public String toString() {
        String result = xml.toString();
        result += "</secs:message>\n";
        return result;
    }

    // Set Parse Message
    public void set(SECSMessage msg) {
        message = msg;
        xml.append("<secs:message sf=\"");
        xml.append(message.name());
        xml.append("\" ");
        if (message.needReply()) {
            xml.append("wait=\"TRUE\" ");
        }
        xml.append("transaction=\"");
        xml.append(message.transaction());
        xml.append("\">\n");
    }

    // Callback to parse item
    public int callWithItem(int type, String itemName, Object value) {
        char[] spaces = new char[currentNest * 2];
        for (int p = 0; p < spaces.length; p++) {
            spaces[p] = ' ';
        }
        String indent = new String(spaces);
        if (type == SECS.LIST) {
            xml.append(indent);
            xml.append("<secs:itemlist name=\"" + "\">\n");
            ArrayList memberList = (ArrayList)value;
            if (memberList != null) {
                int nestSave = currentNest;
                currentNest += 1;
                for (int i = 0; i < memberList.size(); i++) {
                    xml.append(spaces + "  " + memberList.get(i).toString() + "\n");
                }
                currentNest = nestSave;
            }
            xml.append("</secs:itemlist>\n");
        } else {
            xml.append(indent);
            xml.append("<secs:item name=\"");
            xml.append(itemName);
            xml.append("\" type=\"");
            xml.append(SECS.toString(type)); xml.append("\">");
            if (type == SECS.BINARY) {
                xml.append(SECS.hexdump(indent, value));
            } else {
                xml.append(value.toString());
            }
            xml.append("</secs:item>\n");
        }
        listPos++;
        return 0;
    }

    // Callback to parse list
    public int beginList(int nest, int size) {
        currentNest = nest;
        listSize = size;
        listPos = 0;
        char[] spaces = new char[currentNest * 2];
        for (int p = 0; p < spaces.length; p++) {
            spaces[p] = ' ';
        }
        String indent = new String(spaces);
        xml.append(indent); xml.append("<secs:list>\n");
        currentNest++;
        return 0;
    }

    public int endList(int nest) {
        currentNest--;
        char[] spaces = new char[currentNest * 2];
        for (int p = 0; p < spaces.length; p++) {
            spaces[p] = ' ';
        }
        String indent = new String(spaces);
        xml.append(indent);
        xml.append("</secs:list>\n");
        return 0;
    }

    public static void main(String[] args) {

        SECSMessage s1f2 = new SECSMessage("S1F2");
        SECSItem item1 = new SECSItem("MDLN", "JYUGEM");
        SECSItem item2 = new SECSItem("SOFTREV", "1.0.0");
        SECSList node1 = new SECSList();
        node1.add(item1);
        node1.add(item2);
        s1f2.set(node1);
        s1f2.dump();

        SECSMessage s1f14 = new SECSMessage("S1F14");
        SECSList node = new SECSList();
        byte ack = (byte)129;

        SECSItem item0 = new SECSItem("COMMACK", ack);
        node.add(item0);
        node.add(node1);
        s1f14.set(node);

        SECS2XML xml = new SECS2XML();
        int result = s1f14.traverse(xml);
        if (result >= 0) {
            System.out.println("\n*** XML:: ***\n" + xml.toString());
        } else {
            System.out.println("XML:: Ups! error = " + result);
        }
    }

}
