/* $Id: SECSItem.java,v 1.5 2004/06/27 08:01:56 fukasawa Exp $ */

/**
 *  @file    SECSItem.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;
import java.lang.*;
import javax.swing.tree.*;

public class SECSItem extends Object {
    public Object m_value = null;
    public String m_name;
    public int    m_type;

    static String hexTable[] = {
            "0x00", "0x01", "0x02", "0x03", "0x04", "0x05", "0x06", "0x07",
            "0x08", "0x09", "0x0A", "0x0B", "0x0C", "0x0D", "0x0E", "0x0F",
            "0x10", "0x11", "0x12", "0x13", "0x14", "0x15", "0x16", "0x17",
            "0x18", "0x19", "0x1A", "0x1B", "0x1C", "0x1D", "0x1E", "0x1F",
            "0x20", "0x21", "0x22", "0x23", "0x24", "0x25", "0x26", "0x27",
            "0x28", "0x29", "0x2A", "0x2B", "0x2C", "0x2D", "0x2E", "0x2F",
            "0x30", "0x31", "0x32", "0x33", "0x34", "0x35", "0x36", "0x37",
            "0x38", "0x39", "0x3A", "0x3B", "0x3C", "0x3D", "0x3E", "0x3F",
            "0x40", "0x41", "0x42", "0x43", "0x44", "0x45", "0x46", "0x47",
            "0x48", "0x49", "0x4A", "0x4B", "0x4C", "0x4D", "0x4E", "0x4F",
            "0x50", "0x51", "0x52", "0x53", "0x54", "0x55", "0x56", "0x57",
            "0x58", "0x59", "0x5A", "0x5B", "0x5C", "0x5D", "0x5E", "0x5F",
            "0x60", "0x61", "0x62", "0x63", "0x64", "0x65", "0x66", "0x67",
            "0x68", "0x69", "0x6A", "0x6B", "0x6C", "0x6D", "0x6E", "0x6F",
            "0x70", "0x71", "0x72", "0x73", "0x74", "0x75", "0x76", "0x77",
            "0x78", "0x79", "0x7A", "0x7B", "0x7C", "0x7D", "0x7E", "0x7F",
            "0x80", "0x81", "0x82", "0x83", "0x84", "0x85", "0x86", "0x87",
            "0x88", "0x89", "0x8A", "0x8B", "0x8C", "0x8D", "0x8E", "0x8F",
            "0x90", "0x91", "0x92", "0x93", "0x94", "0x95", "0x96", "0x97",
            "0x98", "0x99", "0x9A", "0x9B", "0x9C", "0x9D", "0x9E", "0x9F",
            "0xA0", "0xA1", "0xA2", "0xA3", "0xA4", "0xA5", "0xA6", "0xA7",
            "0xA8", "0xA9", "0xAA", "0xAB", "0xAC", "0xAD", "0xAE", "0xAF",
            "0xB0", "0xB1", "0xB2", "0xB3", "0xB4", "0xB5", "0xB6", "0xB7",
            "0xB8", "0xB9", "0xBA", "0xBB", "0xBC", "0xBD", "0xBE", "0xBF",
            "0xC0", "0xC1", "0xC2", "0xC3", "0xC4", "0xC5", "0xC6", "0xC7",
            "0xC8", "0xC9", "0xCA", "0xCB", "0xCC", "0xCD", "0xCE", "0xCF",
            "0xD0", "0xD1", "0xD2", "0xD3", "0xD4", "0xD5", "0xD6", "0xD7",
            "0xD8", "0xD9", "0xDA", "0xDB", "0xDC", "0xDD", "0xDE", "0xDF",
            "0xE0", "0xE1", "0xE2", "0xE3", "0xE4", "0xE5", "0xE6", "0xE7",
            "0xE8", "0xE9", "0xEA", "0xEB", "0xEC", "0xED", "0xEE", "0xEF",
            "0xF0", "0xF1", "0xF2", "0xF3", "0xF4", "0xF5", "0xF6", "0xF7",
            "0xF8", "0xF9", "0xFA", "0xFB", "0xFC", "0xFD", "0xFE", "0xFF",
        };

    // Constructor
    public SECSItem(String name, int type, Object val) {
        m_name = name;
        m_type = type;
        m_value = val;
    }

    public SECSItem(String name, String val) {
        m_name = name;
        m_value = val;
        m_type = SECS.ASCII;
    }

    public SECSItem(String name, Jis val) {
        m_name = name;
        m_value = new Jis(val);
        m_type = SECS.JIS;
    }

    public SECSItem(String name, Unicode val) {
        m_name = name;
        m_value = new Unicode(val);
        m_type = SECS.UNICODE;
    }

    public SECSItem(String name, byte val) {
        m_name = name;
        Byte[] binary = new Byte[1];
        binary[0] = new Byte(val);
        m_value = binary;
        m_type = SECS.BINARY;
    }

    public SECSItem(String name, byte[] val) {
        m_name = name;
        m_value = val;
        Byte[] binary = new Byte[val.length];
        for (int i = 0; i < val.length; i++) {
            binary[i] = new Byte(val[i]);
        }
        m_value = binary;
        m_type = SECS.BINARY;
    }

    public SECSItem(String name, short val) {
        m_name = name;
        m_value = new Short(val);
        m_type = SECS.INT2;
    }

    public SECSItem(String name, int val) {
        m_name = name;
        m_value = new Integer(val);
        m_type = SECS.INT4;
    }

    public SECSItem(String name, long val) {
        m_name = name;
        m_value = new Long(val);
        m_type = SECS.INT8;
    }

    public SECSItem(String name, float val) {
        m_name = name;
        m_value = new Float(val);
        m_type = SECS.FLOAT4;
    }

    public SECSItem(String name, double val) {
        m_name = name;
        m_value = new Double(val);
        m_type = SECS.FLOAT8;
    }

    public SECSItem(String name, boolean val) {
        m_name = name;
        m_value = new Boolean(val);
        m_type = SECS.BOOLEAN;
    }

    public SECSItem(String name, Int1 val) {
        m_name = name;
        m_value = new Int1(val);
        m_type = SECS.INT1;
    }

    public SECSItem(String name, UInt1 val) {
        m_name = name;
        m_value = new UInt1(val);
        m_type = SECS.UINT1;
    }

    public SECSItem(String name, UShort val) {
        m_name = name;
        m_value = new UShort(val);
        m_type = SECS.UINT2;
    }

    public SECSItem(String name, UInteger val) {
        m_name = name;
        m_value = new UInteger(val);
        m_type = SECS.UINT4;
    }

    public SECSItem(String name, ULong val) {
        m_name = name;
        m_value = new ULong(val);
        m_type = SECS.UINT8;
    }

    public SECSItem(String name, short[] values) {
        m_name = name;
        Short[] valArray = new Short[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new Short(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.INT2 | SECS.ARRAY);
    }

    public SECSItem(String name, int[] values) {
        m_name = name;
        Integer[] valArray = new Integer[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new Integer(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.INT4 | SECS.ARRAY);
    }

    public SECSItem(String name, long[] values) {
        m_name = name;
        Long[] valArray = new Long[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new Long(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.INT8 | SECS.ARRAY);
    }

    public SECSItem(String name, float[] values) {
        m_name = name;
        Float[] valArray = new Float[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new Float(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.FLOAT4 | SECS.ARRAY);
    }

    public SECSItem(String name, double[] values) {
        m_name = name;
        Double[] valArray = new Double[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new Double(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.FLOAT8 | SECS.ARRAY);
    }

    public SECSItem(String name, Int1[] values) {
        m_name = name;
        Int1[] valArray = new Int1[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new Int1(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.INT1 | SECS.ARRAY);
    }

    public SECSItem(String name, UInt1[] values) {
        m_name = name;
        UInt1[] valArray = new UInt1[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new UInt1(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.UINT1 | SECS.ARRAY);
    }

    public SECSItem(String name, UShort[] values) {
        m_name = name;
        UShort[] valArray = new UShort[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new UShort(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.UINT2 | SECS.ARRAY);
    }

    public SECSItem(String name, UInteger[] values) {
        m_name = name;
        UInteger[] valArray = new UInteger[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new UInteger(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.UINT4 | SECS.ARRAY);
    }

    public SECSItem(String name, ULong[] values) {
        m_name = name;
        ULong[] valArray = new ULong[values.length];
        for (int i = 0; i < values.length; i++) {
            valArray[i] = new ULong(values[i]);
        }
        m_value = valArray;
        m_type = (SECS.UINT8 | SECS.ARRAY);
    }

    public SECSItem(String name, String typeName, String val) throws SECSException {
        m_name = name;
        m_type = toType(typeName);
        if (m_type < 0) {
            throw new SECSException("Not support format." + typeName);
        }
        if (m_type == SECS.ASCII || (val != null && val.length() > 0)) {
            try {
                m_value = parseItemValue(m_type, val);
            } catch (SECSException e) {
                throw e;
            }
        }
    }

    public SECSItem(String name, ArrayList mnbr)
                            throws RuntimeException {
        m_name = name;
        m_type = SECS.LIST;
        m_value = new ArrayList(mnbr);
    }

    public String toString() {
        return "";
    }

    public String name()  { return m_name; }
    public int    type()  { return m_type; }
    public Object value() { return m_value; }
    public String typeName() { return SECS.toString(m_type); }

    //
    // Parse list in item
    //
    Object parseListValue(int type, String varStr) throws SECSException {
        Object valObj = null;
        ArrayList objs = new ArrayList();
        Object aObj;

        StringTokenizer tokenizer = new StringTokenizer(varStr);
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                aObj = parseOneValue(type, token);
                objs.add(aObj);
            }
        } catch (SECSException e) {
            throw e;
        }
        return objs;
    }
    //
    // Parse string to value
    //
    Object parseItemValue(int type, String varStr) throws SECSException {
        Object valObj = null;
        try {
            valObj = SECS.parseValueOf(type, varStr);
        } catch (SECSException e) {
            throw e;
        }
        return valObj;
    }

    Object parseOneValue(int type, String token) throws SECSException {
        Object value;
        try {
            value = SECS.convertValueOf(type, token);
        } catch (SECSException e) {
            value = null;
        }
        return value;
    }

    public static int toType(String typeName) {
        int format = -1;
        try {
            format = SECS.toFormat(typeName);
        } catch (SECSException e) {

        }
        return format;
    }

    //
    // Parse message
    //
    public int parseItem(int nest, SECSParser userParser) {
        return userParser.callWithItem(m_type, m_name, m_value);
    }

    //
    // Get value string
    //
    public String getValueString() {
        return SECS.hexdump("", m_value);
    }

    private String hexdump(String indent) {
        return SECS.hexdump(indent, m_value);
    }

    public void dump(int nest) {
        String indent = new String(new char[nest * 2]);
        if (m_type == SECS.BINARY) {
            System.out.println(indent + "<secs:item name=\"" + m_name +
                               "\" type=\"" + typeName() + "\">" +
                               hexdump(indent) +
                               "</secs:item>");
        } else if (m_type == SECS.LIST) {
            System.out.println(indent + "<secs:itemlist name=\"" + m_name + "\">");
            ArrayList member = (ArrayList)m_value;
            if (member != null) {
                for (int i = 0; i < member.size(); i ++) {
                    System.out.println(indent + "  " + member.get(i).toString());
                }
            }
            System.out.println(indent + "</secs:itemlist>");
        } else {
            String val = "";
            if (m_value != null) {
                if (m_type > SECS.ARRAY) {
                    Object[] objs = (Object[])m_value;
                    for (int i = 0; i < objs.length; i ++) {
                        if (i > 0)
                            val += " ";
                        val += objs[i].toString();
                    }
                } else {
                    val = m_value.toString();
                }
            }
            System.out.println(indent + "<secs:item name=\"" + m_name +
                               "\" type=\"" + typeName() + "\">" +
                               val + "</secs:item>");
        }
    }
}

