/* $Id: SECSResponder.java,v 1.4 2004/06/20 15:23:40 fukasawa Exp $ */

/**
 *  @file    SECSResponder.java
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package com.jyugem.secs;

import java.util.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.tree.*;

public class SECSResponder extends Thread {
    SECSDriver m_driver;
    ResponseMaker m_auto;
    MessageBox m_msgbox;
    boolean    m_dispatch;

    public SECSResponder(SECSManager manager) {
        m_driver = manager.driver();
        m_auto   = new ResponseMaker();
        m_auto.open(manager.getDefaultMessages());
        m_msgbox = manager.messageBox();
        m_dispatch = false;
    }

    public synchronized boolean isDispatch() {
        return m_dispatch;
    }

    public synchronized void setDispatch(boolean tf) {
        m_dispatch = tf;
    }

    public void run() {
        SECSMessage msg;
        SECSMessage reply;
        while (true) {
            try {
                // Receive
                msg = m_driver.receive();

                if (isDispatch()) {
                    //  Test script is here.
                    m_msgbox.put(msg);

                } else {
                    reply = null;

                    // Auto response
                    if (reply == null) {
                        reply = m_auto.response(msg);
                    }

                    // Send reply
                    if (reply != null) {
                        m_driver.send(reply);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            finally {
            }
        }
    }

}

