// $Id: JSItem.h,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSItem.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JSITEM_H
#define JSITEM_H

#include "BS2Item.h"
#include "JSAtom.h"

class JSItem
{
public:
    JSItem()  {}
    ~JSItem() {}

    void    init(JNIEnv * jenv);
    jclass  getClass() { return m_class; }
    jobject getValue(jobject itemObj);

    // secs value to item object
    jobject toItemObj(BS2Item * item);

    // jobject to item
    BS2Item * toItem(jobject obj);

    // Global access method
    static JSItem * instance();

protected:
    JNIEnv *  m_jenv;
    jclass    m_class;

    jmethodID m_new;         // SECSItem(String name, int type, Object val);

    jfieldID  m_nameFld;
    jfieldID  m_valueFld;
    jfieldID  m_typeFld;
};

#endif
