// $Id$

//=============================================================================
/**
 *  @file    HSAlarmManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSAlarmManager.h"
#include "HSMainManager.h"
#include "HSServer.h"
#include "HSEventManager.h"
#include "HSInfoManager.h"
#include "HSSECSDevice.h"
#include "HSSECSDevice.h"
#include "jyugem/gem/JGTaskTrigger.h"
#include "jyugem/gem/JGLogTime.h"
#include "BS2ACKMessage.h"
#include "BS2ErrorMessage.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

#include "jyugem/gem/JGVariable.h"

static HSAlarmManager * _manager = NULL;

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
HSAlarmManager::HSAlarmManager() : JGAlarmManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSAlarmManager::HSAlarmManager");
}

//-----------------------------------------------------------------------------
HSAlarmManager::~HSAlarmManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSAlarmManager::~HSAlarmManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
HSAlarmManager * HSAlarmManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::instance");
    if (_manager == NULL)
    {
        _manager = new HSAlarmManager;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Setup alarm.
//-----------------------------------------------------------------------------
int HSAlarmManager::setup(int tid, BYTE aled, JGid& alid)
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::setup");

    BS2Message * msg = this->enabled(aled, alid);
    int result = this->send(msg, tid);
    return result;
}

//-----------------------------------------------------------------------------
int HSAlarmManager::setupAll(int tid, BYTE aled)
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::setup");

    BS2Message * msg = this->allEnabled(aled);
    int result = this->send(msg, tid);
    return result;
}


//-----------------------------------------------------------------------------
// Change the enable flag
//-----------------------------------------------------------------------------
BS2Message * HSAlarmManager::enabled(BYTE aled, JGid& id)
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::enabled");

    this->changeEnabled(id, (aled & 0x80) ? true : false);

    BS2Message * msg = BS2Message::factory(SFCODE(5,3));
    BS2ListItem * bodylist = new BS2ListItem();
    BS2Item * item;
    item = BS2Item::factory(_TX("ALED"), new BS2Binary(aled));
    bodylist->add(item);
    item = BS2Item::factory(_TX("ALID"), BS2Atom::factory(id));
    bodylist->add(item);

    msg->add(bodylist);
    return msg;
}

//-----------------------------------------------------------------------------
// Change all enable flags
//-----------------------------------------------------------------------------
BS2Message * HSAlarmManager::allEnabled(BYTE aled)
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::allEnabled");

    this->changeEnabledAll((aled & 0x80) ? true : false);

    BS2Message * msg = BS2Message::factory(SFCODE(5,3));
    BS2ListItem * bodylist = new BS2ListItem();
    BS2Item * item;
    item = BS2Item::factory(_TX("ALED"), new BS2Binary(aled));
    bodylist->add(item);

    JGid empty_id;
    HSInfoManager * info_mngr = (HSInfoManager *)this->equipment()->getInfoManager();
    empty_id.m_t = info_mngr->alidFormat();
    item = BS2Item::factory(_TX("ALID"), BS2Atom::factory(empty_id));
    bodylist->add(item);

    msg->add(bodylist);
    return msg;
}


//-----------------------------------------------------------------------------
// List Enabled Alarm message (S5F1 -> S5F2)
//-----------------------------------------------------------------------------
class _ParseAlarm : public BS2Traverser
{
    friend class HSAlarmManager;
public:
    _ParseAlarm() : m_alcd(false), m_alid(0), m_altx(NULL) {}
    virtual ~_ParseAlarm() {}

    int    m_state;
    int    m_alcd;
    int    m_alid;
    string m_altx;

    virtual int parseItem(BS2Item * item) {
        TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::_ParseAlarm::parseItem");
        BS2Atom * atom = item->atom();
        if (item->name() == _TX("ALCD"))
        {
             if (atom->isBinary())
             {
                 BYTE * bin = ((BS2Binary *)atom)->value();
                 m_state = ((*bin & 0x80) != 0) ? 1 : 0;
                 m_alcd = (*bin & 0x7F);
             }
             else
             {
                 TRACE_DEBUG((_TX("ALCD format is not binary(0x%x).\n"),
                              atom->format()));
                 return -1;
             }
        }
        else if (item->name() == _TX("ALID"))
        {
            JGid alid;
            atom->get(alid);
            m_alid = alid.getInt();
        }
        else if (item->name() == _TX("ALTX"))
        {
            if (! atom->isAscii())
            {
                TRACE_ERROR((_TX("Illegal alarm text format(0x%x) \n"),
                            atom->format()));
                return -1;
            }
            m_altx = ((BS2Ascii *)atom)->value();
        }
        return 0;
    }
};

//-----------------------------------------------------------------------------
BS2Message * HSAlarmManager::alarmReport(BS2Message * msg)
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::alarmReport");

    BS2Message * replymsg;
    _ParseAlarm alarmInfo;
    int result = msg->traverse(&alarmInfo);    // parse S5F1
    if (result < 0)
    {   // reply normal acknowlede, always.
        replymsg = BS2Message::response(msg, (BYTE)ACK_OK, _TX("ACKC5"));
        return replymsg;
    }

    HSServer * eqsvr = (HSServer *)this->equipment();
    eqsvr->alarm_report(alarmInfo.m_alid, alarmInfo.m_state,
                        alarmInfo.m_altx, alarmInfo.m_alcd, 0, _TX(""));

    //
    replymsg = BS2Message::response(msg, (BYTE)ACK_OK, _TX("ACKC5"));
    return replymsg;
}

//-----------------------------------------------------------------------------
// List Enabled Alarm message (S5F4)
//-----------------------------------------------------------------------------
void HSAlarmManager::alarmAck(BS2Message * msg)
{
    TRACE_FUNCTION(TRL_LOW, "HSAlarmManager::alarmReport");

    BS2Item * item = msg->getItem(_TX("ACKC5"));
    BS2Atom * atom = item->atom();
    int ack = atom->getInt();
    HSServer * eqsvr = (HSServer *)this->equipment();
    UINT tid = this->eraseTransaction(msg->transNum());
    eqsvr->command_ack(tid, ack, ((ack == 0) ? _TX("") : item->errtext(ack)));
}

//-----------------------------------------------------------------------------
// Thread of received message event.
//-----------------------------------------------------------------------------
BS2Message * HSAlarmManager::msg_svc(JGMessageTrigger * trigger,
                                     BS2Message * msg)
{
    ACE_UNUSED_ARG(trigger);
    BS2Message * replymsg = NULL;

    if (msg->sf() == SFCODE(5,1))
    {
        replymsg = this->alarmReport(msg);
    }
    else if (msg->sf() == SFCODE(5,4))
    {
        this->alarmAck(msg);
    }
    else
    {   // Unexpected message
        replymsg = this->unrecognized(msg);
    }

    return replymsg;
}

