// $Id$

//=============================================================================
/**
 *  @file    HSDevice.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSDevice.h"
#include "HSMainManager.h"

//-----------------------------------------------------------------------------
//
// HOST Simulator Device
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int HSDevice::init(void * param)
{
    TRACE_FUNCTION(TRL_LOW, "HSDevice::init");

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Send a block
//-----------------------------------------------------------------------------
int HSDevice::send(const char * data, size_t dataSize, bool lengthSending)
{
    TRACE_FUNCTION(TRL_LOW, "HSDevice::send");

    ACE_MT(ACE_GUARD_RETURN(ACE_Thread_Mutex, ace_mon, this->m_lock, -1));

    int result;
    if (lengthSending)
    {
        BYTE len[sizeof(long)];
        len[0] = (dataSize >> 24) & 0xFF;
        len[1] = (dataSize >> 16) & 0xFF;
        len[2] = (dataSize >> 8) & 0xFF;
        len[3] = dataSize & 0xFF;
        result = m_stream.send(len, sizeof(int));
        if (result != sizeof(int))
        {
            return BEE_ERROR;
        }
    }
    if (m_hexdump)
    {
        ACE_HEX_DUMP((LM_DEBUG, data, dataSize));
    }
    result = m_stream.send(data, dataSize);
    return BEE_SUCCESS;
}

//------------------------------------------------------------------------------
// Start communication in service
//------------------------------------------------------------------------------
int HSDevice::svc()
{
    TRACE_FUNCTION(TRL_LOW, "HSDevice::src");
    TRACE_DEBUG((_TX("(%t) vfei manager sevice..... \n")));

    size_t bytes_read;
    size_t bufsize = 16384;
    BCHAR sizeBuf[sizeof(int)];
    char * readbuf = (char *)malloc(bufsize);
    
    m_addr.set(m_port, m_hostname.c_str());

    if (m_mode == PASSIVE)
    {
        if (m_peer_acceptor.open(m_addr) == -1)
        {
            TRACE_ERROR((_TX("%p\n"), _TX("open")));
            return -1;
        }

        if (m_peer_acceptor.get_local_addr(m_addr) == -1)
        {
            TRACE_ERROR((_TX("%p\n"), _TX("get_local_addr")));
            return -1;
        }

        // Activate server
        if (m_peer_acceptor.accept(m_stream) == -1)
        {
            TRACE_ERROR((_TX("%p\n"), _TX("accept")));
            m_peer_acceptor.close();
            return -1;
        }
        TRACE_DEBUG((_TX("Connected passive at port %d\n"),
                     m_addr.get_port_number()));
    }
    else
    {
        int retval = m_con.connect(m_stream, m_addr);
        while (retval == -1)
        {
            ACE_OS::sleep(1);
            if (m_reqStop == 1)
            {
                TRACE_DEBUG((_TX("(%p) terminate hsms receive thread.\n")));
                return -1;
            }
            retval = m_con.connect(m_stream, m_addr);
        }
        TRACE_DEBUG((_TX("connected active at port %d.\n"),
                     m_addr.get_port_number()));
    }

    while (1)
    {
        size_t r_bytes = m_stream.recv(sizeBuf, sizeof(int));
        if (r_bytes == -1)
        {
            TRACE_ERROR((_TX("%p\n"), _TX("recv")));
            break;
        }
        else if (r_bytes == 0)
        {   // Close new endpoint (listening endpoint stays open).
            TRACE_DEBUG((_TX("(%P|%t) reached end of input, connection closed by endpoint\n")));
            break;
        }
        else if (r_bytes == sizeof(int))
        {
            size_t rsize = (sizeBuf[0] << 24) + (sizeBuf[1] << 16) +
                           (sizeBuf[2] << 8) + sizeBuf[3];
            if (rsize > bufsize)
            {
                TRACE_ERROR((_TX("receive data overflow (%d)\n"), rsize));
                free(readbuf);
                bufsize = (rsize + 4095) & 0xFFFFF000;
                readbuf = (char *)malloc(bufsize);             
            }
            else
            {
                bytes_read = m_stream.recv_n(readbuf, rsize);
                if (bytes_read != rsize)
                {
                    TRACE_ERROR((_TX("not equal received data size (%d:%d)\n"),
                                 bytes_read, rsize));
                    break;
                }
                else
                {
                    if (m_hexdump)
                    {
                        ACE_HEX_DUMP((LM_DEBUG, readbuf, bytes_read));
                    }
                    //
                    // put vfei message to parser
                    //
                    int result = HSMainManager::instance()->parse_vfei(readbuf, bytes_read);
                    if (result < 0)
                    {
                        ;
                    }
                }
            }
        }
        else
        {
            TRACE_ERROR((_TX("not received message size (%d)\n"), r_bytes));
        }
    }

    // Close the connection completely.
    if (m_stream.close_writer() == -1)
    {
        TRACE_ERROR((_TX("%p\n"), _TX("close_writer")));
    }
    if (m_stream.close () == -1)
    {
        ACE_ERROR_RETURN ((LM_ERROR, "%p\n", "close"), 1);
    }
    if (m_mode == PASSIVE)
    {
        m_peer_acceptor.close();
    }
    return 0;
}

