// $Id$

//=============================================================================
/**
 *  @file    HSInfoManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSInfoManager.h"
#include "HSServer.h"
#include "HSDevice.h"
#include "jyugem/gem/JGTimeModule.h"
#include "jyugem/gem/JGTaskTrigger.h"
#include "BS2ACKMessage.h"
#include "BS2ErrorMessage.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"
#include "b_varinfo.h"


static HSInfoManager * _manager = NULL;


//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
HSInfoManager::HSInfoManager() : JGInfoManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSInfoManager::HSInfoManager");

}

//-----------------------------------------------------------------------------
HSInfoManager::~HSInfoManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSInfoManager::~HSInfoManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
HSInfoManager * HSInfoManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "HSInfoManager::instance");
    if (_manager == NULL)
    {
        _manager = new HSInfoManager;
        JGInfoManager::instance(_manager);
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Set equipment constant
//-----------------------------------------------------------------------------
int HSInfoManager::setParam(int tid, const std::vector<any_item>& params)
{
    TRACE_FUNCTION(TRL_LOW, "HSInfoManager::setParam");

    std::vector<JGVariable *> vars;
    if (params.size() > 0)
    {
        HSInfoManager * info_mngr = (HSInfoManager *)this->equipment()->getInfoManager();
        for (size_t i = 0; i < params.size(); i++)
        {
            JGid vid;
            vid.set(params[i].m_pname, info_mngr->vidFormat());
            JGVariable * var = info_mngr->variable(vid);
            if (var == NULL)
            {
                continue;
            }
            var->setv(params[i].m_value);
            vars.push_back(var);
        }
    }
    BS2Message * msg = this->make_s2f15(vars);
    int result = this->send(msg, tid);
    return result;
}

//-----------------------------------------------------------------------------
// Inquire Status value
//-----------------------------------------------------------------------------
int HSInfoManager::inqStatus(int tid, const std::vector<std::string>& vids,
                             const std::string& file)
{
    TRACE_FUNCTION(TRL_LOW, "HSInfoManager::inqStatus");

    std::vector<JGid> svids;
    if (vids.size() > 0)
    {
        HSInfoManager * info_mngr = (HSInfoManager *)this->equipment()->getInfoManager();
        for (size_t i = 0; i < vids.size(); i++)
        {
            JGid vid;
            vid.set(vids[i], info_mngr->vidFormat());
            svids.push_back(vid);
        }
    }
    m_fileName = file;
    BS2Message * msg = this->make_s1f3(svids);
    int result = this->send(msg, tid);
    return result;
}

//-----------------------------------------------------------------------------
// Make to set equipment constant variables.
//-----------------------------------------------------------------------------
BS2Message * HSInfoManager::make_s2f15(vector<JGVariable *>& ecvs)
{
    TRACE_FUNCTION(TRL_LOW, "HSInfoManager::make_s2f15");
    BS2Message * msg = BS2Message::factory(SFCODE(2,15));
    BS2ListItem * rootlist = new BS2ListItem;
    BS2Item * item;
    if (ecvs.empty())
    {
        JGVidTable * ecvtable = this->ecvTable();
        JGVidTable::iterator iter = ecvtable->begin();
        for ( ; iter != ecvtable->end(); iter++)
        {
            JGVariable * var = iter->second;
            if (var->enabled())
            {
                if ((item = var->makeEcvItem()) != NULL)
                {
                    rootlist->add(item);
                }
                else
                {
                    TRACE_ERROR((_TX("%s can not make item.\n"),
                        var->name().c_str()));
                }
            }
        }
    }
    else
    {
        for (size_t i = 0; i < ecvs.size(); i++)
        {
            JGVariable * var = ecvs[i];
            if ((item = var->makeEcvItem()) != NULL)
            {
                rootlist->add(item);
            }
            else
            {
                TRACE_ERROR((_TX("%s is not ECV.\n"), var->name().c_str()));
            }
        }
    }
    msg->add(rootlist);
    return msg;
}

//-----------------------------------------------------------------------------
// Make to get status variables.
//-----------------------------------------------------------------------------
BS2Message * HSInfoManager::make_s1f3(vector<JGid>& svids)
{
    TRACE_FUNCTION(TRL_LOW, "HSInfoManager::make_s1f3");
    BS2Message * msg = BS2Message::factory(SFCODE(1,3));
    BS2ListItem * rootlist = new BS2ListItem;
    BS2Item * item;
    if (svids.size() > 0)
    {
        for (size_t i = 0; i < svids.size(); i++)
        {
            item = BS2Item::factory(_TX("SVID"), BS2Atom::factory(svids[i]));
            if (item != NULL)
            {
                rootlist->add(item);
            }
            else
            {
                TRACE_ERROR((_TX("%s is not SV.\n"),
                    svids[i].toString().c_str()));
            }
        }
    }
    msg->add(rootlist);
    return msg;
}

//-----------------------------------------------------------------------------
// Thread of received message event.
//-----------------------------------------------------------------------------
BS2Message * HSInfoManager::msg_svc(JGMessageTrigger * trigger, BS2Message * msg)
{
    BS2Message * replymsg = NULL;

    {   // Unexpected message
        replymsg = this->unrecognized(msg);
    }

    return replymsg;
}

