// $Id$

//=============================================================================
/**
 *  @file    HSInitializeCmd.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSInitializeCmd.h"
#include "HSServer.h"
#include "HSEventManager.h"
#include "HSAlarmManager.h"
#include "HSInfoManager.h"
#include "HSSpoolManager.h"
#include "HSDevice.h"
#include "jyugem/gem/JGTaskTrigger.h"
#include "jyugem/gem/JGLogTime.h"
#include "jyugem/gem/JGTimeModule.h"
#include "BS2MessageDictionary.h"
#include "BS2ACKMessage.h"
#include "BS2ErrorMessage.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"

class StepEstablishCommunication : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Establish Communication.\n")));

        if (context->online())
        {
            return context->next();
        }
        else
        {
            BS2Message * msg = BS2Message::factory(SFCODE(1,13));
            context->send(msg);
            context->doSequence();
        }
        return 0;
    }
};

class StepRequestOnline : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Host Online Request.\n")));

        BS2Message * msg = BS2Message::factory(SFCODE(1,17));
        context->send(msg);
        return 0;
    }
};

class StepDataTimeSet : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: DateTime Setup.\n")));

        BS2Message * msg = JGTimeModule::instance()->make_s2f31();
        context->send(msg);
        return 0;
    }
};

class StepSpoolData : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Clear Spool Data.\n")));

        BS2Message * msg = JGSpoolManager::instance()->make_s6f23();
        context->send(msg);
        return 0;
    }
};

class StepEquipmentConstant : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Set Equipment Constant Data.\n")));

        BS2Message * msg = JGInfoManager::instance()->make_s2f15(context->getConsts());
        if (msg != NULL)
        {
            context->send(msg);
        }
        else
        {
            return context->next();
        }
        return 0;
    }
};

class StepDisableEvent : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Disable Events.\n")));

        BS2Message * msg = HSEventManager::instance()->allEnabled(false);
        context->send(msg);
        return 0;
    }
};

class StepEnableEvent : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Enable Events.\n")));

        BS2Message * msg = HSEventManager::instance()->allEnabled(true);
        context->send(msg);
        return 0;
    }
};

class StepResetReport : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Reset Reports.\n")));

        BS2Message * msg = HSEventManager::instance()->resetReports();
        context->send(msg);
        return 0;
    }
};

class StepDefineReport : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Define Reports.\n")));

        BS2Message * msg = HSEventManager::instance()->defineReports();
        context->send(msg);
        return 0;
    }
};

class StepResetEvent : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Reset Events.\n")));

        BS2Message * msg = HSEventManager::instance()->resetEventReport();
        context->send(msg);
        return 0;
    }
};

class StepLinkEvent : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Link Event Report.\n")));

        BS2Message * msg = HSEventManager::instance()->linkEventReport();
        context->send(msg);
        return 0;
    }
};

class StepDisableAlarm : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Disable Alarm.\n")));

        BS2Message * msg = HSAlarmManager::instance()->allEnabled(false);
        context->send(msg);
        return 0;
    }
};

class StepEquipmentStatus : public CmdStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: Get Status Value.\n")));

        BS2Message * msg = JGInfoManager::instance()->make_s1f3(context->getSvids());
        if (msg != NULL)
        {
            context->send(msg);
        }
        else
        {
            return context->next();
        }
        context->send(msg);
        return 0;
    }
};


class StepTerminate : public TerminateStep
{
    int evaluate(HSInitializeCmd * context)
    {
        ACE_DEBUG((LM_DEBUG, ACE_TEXT("STEP: End.\n")));
        // send ack to host
        context->close();
        return 0;
    }
};

static HSInitializeCmd * _manager = NULL;

static StepEstablishCommunication _step_estcomm;
static StepRequestOnline          _step_reqonline;
static StepDataTimeSet            _step_datetime;
static StepSpoolData              _step_spooldata;
static StepEquipmentConstant      _step_constant;
static StepDisableEvent           _step_disable_event;
static StepEnableEvent            _step_enable_event;
static StepResetReport            _step_reset_report;
static StepResetEvent             _step_reset_event;
static StepDefineReport           _step_define_report;
static StepLinkEvent              _step_link_event;
static StepDisableAlarm           _step_disable_alarm;
static StepEquipmentStatus        _step_equipment_status;
static StepTerminate              _step_terminate;

//-----------------------------------------------------------------------------
// Callback routine of event
//-----------------------------------------------------------------------------
struct EquipmentOffline : public JGEvent::Callback
{
    EquipmentOffline(HSInitializeCmd * context) : Callback(context) {}

    virtual void call(JGEvent * event)
    {
        HSInitializeCmd * m_initcmd = static_cast<HSInitializeCmd *>(m_userData);
        m_initcmd->online(false);
    }
};

struct OnlineRemote : public JGEvent::Callback
{
    OnlineRemote(HSInitializeCmd * context) : Callback(context) {}

    virtual void call(JGEvent * event)
    {
        HSInitializeCmd * m_initcmd = static_cast<HSInitializeCmd *>(m_userData);
        m_initcmd->online(true);
    }
};

static EquipmentOffline * _offline_callback = NULL;
static OnlineRemote *     _remote_callback = NULL;

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
HSInitializeCmd::HSInitializeCmd() : JGManager(_TX("INITIALIZE"))
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSInitializeCmd::HSInitializeCmd");
    m_cmdseq.context(this);
}

//-----------------------------------------------------------------------------
HSInitializeCmd::~HSInitializeCmd()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSInitializeCmd::~HSInitializeCmd");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
HSInitializeCmd * HSInitializeCmd::instance()
{
    TRACE_FUNCTION(TRL_LOW, "HSInitializeCmd::instance");
    if (_manager == NULL)
    {
        _manager = new HSInitializeCmd;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------------------
int HSInitializeCmd::init(void * param)
{
    TRACE_FUNCTION(TRL_LOW, "HSInitializeCmd::init");

    InitConfig * config = reinterpret_cast<InitConfig *>(param);

    BS2MessageType * msgtype;
    BS2MessageDictionary * msgdict = BS2MessageDictionary::instance();

//    msgtype = msgdict->search(SFCODE(1,4));
//    m_s1f4_name = msgtype->manager();
//    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(1,13));
    m_s1f13_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(1,14));
    m_s1f14_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(1,18));
    m_s1f18_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(2,16));
    m_s2f16_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(2,32));
    m_s2f32_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(2,34));
    m_s2f34_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(2,36));
    m_s2f36_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(2,38));
    m_s2f38_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(3,24));
    m_s3f24_name = msgtype->manager();
    msgtype->manager(this->name());

    msgtype = msgdict->search(SFCODE(6,23));
    m_s6f23_name = msgtype->manager();
    msgtype->manager(this->name());

    m_cmdseq.add(&_step_estcomm);
    if (config->m_online)
    {
        m_cmdseq.add(&_step_reqonline);
    }
    if (config->m_datetime)
    {
        m_cmdseq.add(&_step_datetime);
    }
    if (config->m_spool)
    {
        m_cmdseq.add(&_step_spooldata);
    }
    if (config->m_eqconst)
    {
        m_cmdseq.add(&_step_constant);
    }
    if (config->m_event)
    {
        m_cmdseq.add(&_step_disable_event);
        m_cmdseq.add(&_step_reset_report);
        m_cmdseq.add(&_step_reset_event);
        m_cmdseq.add(&_step_define_report);
        m_cmdseq.add(&_step_link_event);
        m_cmdseq.add(&_step_enable_event);
    }
//    if (config->m_eqstate)
//    {
//        m_cmdseq.add(&_step_equipment_status);
//    }
    m_cmdseq.add(&_step_terminate);

    // Entry callback routines
    HSEventManager * event_mngr = (HSEventManager *)m_equipment->getEventManager();
    JGEvent * event = event_mngr->findByService(EVT_OFFLINE);
    _offline_callback = new EquipmentOffline(this);
    event->append(_offline_callback);

    event = event_mngr->findByService(EVT_REMOTE);
    _remote_callback = new OnlineRemote(this);
    event->append(_remote_callback);

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Close .
//-----------------------------------------------------------------------------
int HSInitializeCmd::close(int flag)
{
    TRACE_FUNCTION(TRL_LOW, "HSInitializeCmd::close");
    ACE_UNUSED_ARG(flag);

    BS2MessageType * msgtype;
    BS2MessageDictionary * msgdict = BS2MessageDictionary::instance();

//    msgtype = msgdict->search(SFCODE(1,4));
//    msgtype->manager(m_s1f4_name);

    msgtype = msgdict->search(SFCODE(1,13));
    msgtype->manager(m_s1f13_name);

    msgtype = msgdict->search(SFCODE(1,14));
    msgtype->manager(m_s1f14_name);

    msgtype = msgdict->search(SFCODE(1,18));
    msgtype->manager(m_s1f18_name);

    msgtype = msgdict->search(SFCODE(2,16));
    msgtype->manager(m_s2f16_name);

    msgtype = msgdict->search(SFCODE(2,32));
    msgtype->manager(m_s2f32_name);

    msgtype = msgdict->search(SFCODE(2,34));
    msgtype->manager(m_s2f34_name);

    msgtype = msgdict->search(SFCODE(2,36));
    msgtype->manager(m_s2f36_name);

    msgtype = msgdict->search(SFCODE(2,38));
    msgtype->manager(m_s2f38_name);

    msgtype = msgdict->search(SFCODE(3,24));
    msgtype->manager(m_s3f24_name);

    msgtype = msgdict->search(SFCODE(6,23));
    msgtype->manager(m_s6f23_name);

    HSServer * mainsrv = (HSServer *)this->equipment();
    mainsrv->command_ack(m_tid, 0, _TX(""));

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Parser of status event.
//-----------------------------------------------------------------------------
void HSInitializeCmd::online(bool tf)
{
    TRACE_FUNCTION(TRL_LOW, "HSInitializeCmd::online");

    m_online = tf;
    m_equipment->online(tf);

    return ;
}

//-----------------------------------------------------------------------------
// Parser of status event.
//-----------------------------------------------------------------------------
int HSInitializeCmd::notify_svc(JGNotifyTrigger * trigger)
{
    TRACE_FUNCTION(TRL_LOW, "HSInitializeCmd::notify_svc");

    int result = BEE_SUCCESS;
    if (trigger->name() == _TX("start"))
    {
        this->m_cmdseq.start();
    }
    else
    {
        TRACE_DEBUG((_TX("unknown notify [%s].\n"), trigger->charName()));
        result = -1;
    }
    return result;
}

//-----------------------------------------------------------------------------
// Thread of received message event.
//-----------------------------------------------------------------------------
BS2Message * HSInitializeCmd::msg_svc(JGMessageTrigger * trigger,
                                      BS2Message * msg)
{
    TRACE_FUNCTION(TRL_LOW, "HSInitializeCmd::notify_svc");

    BS2Message * replymsg = NULL;
    if (msg->sf() == SFCODE(1,1))
    {
        this->online(true);
        replymsg = BS2Message::response(msg);
        if (replymsg)
        {
            BS2ListItem * rootlist = new BS2ListItem;
            replymsg->add(rootlist);
        }
    }
    else if (msg->sf() == SFCODE(1,13))
    {
        this->online(true);
        replymsg = BS2Message::response(msg);
        if (replymsg)
        {
            BS2ListItem * rootlist = new BS2ListItem;
            replymsg->add(rootlist);
            BS2Item * commack = BS2Item::factory(_TX("COMMACK"),
                                                 new BS2Binary((BYTE)0));
            rootlist->add(commack);
            BS2ListItem * mdln = new BS2ListItem;
            rootlist->add(mdln);
        }
    }
    else if (msg->sf() == SFCODE(1,2))
    {
        this->online(true);
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(1,14))
    {
        this->online(true);
        if (m_sequence.value())
        {
            m_sequence = false;
            this->m_cmdseq.next();
        }
    }
//    else if (msg->sf() == SFCODE(1,4))
//    {
//        this->m_cmdseq.next();
//    }
    else if (msg->sf() == SFCODE(1,18))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(2,16))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(2,32))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(2,34))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(2,36))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(2,38))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(2,44))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(3,24))
    {
        this->m_cmdseq.next();
    }
    else if (msg->sf() == SFCODE(6,24))  // Request Spool Data Acknowledge
    {
        this->m_cmdseq.next();
    }
    else
    {   // Unexpected message
    }

    return replymsg;
}



