// $Id$

//=============================================================================
/**
 *  @file    HSMainManager.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSMAINMANAGER_H
#define HSMAINMANAGER_H

#include "jyugem/gem/JGEquipmentManager.h"
#include "jyugem/gem/rcmd.h"
#include "HSServer.h"

// Forward declaration
class  HSServer;
class  HSDevice;
typedef jyugem::cell::rcmd host_cmd;

//-----------------------------------------------------------------------------
//
// Host Simulator Object
//
//-----------------------------------------------------------------------------
class BEE_Export HSMainManager : public JGEquipmentManager
{
public:
    HSMainManager() : JGEquipmentManager() {}
    HSMainManager(const BCHAR * name, const BCHAR * logParam = NULL)
        : JGEquipmentManager(name, logParam) {}
    virtual ~HSMainManager() {}

    virtual int init(void * argv = 0);
    virtual int svc(void);
    virtual int put(ACE_Message_Block * mb, ACE_Time_Value *tv = 0);

    HSServer * dev_server(const string& devname = _TX(""))
    {
        //HSServer * hsvr = dynamic_cast<HSServer *>(this->equipment(devname));
        HSServer * hsvr = dynamic_cast<HSServer *>(this->equipment(""));
        return hsvr;
    }
    int begin(void * param = NULL);
    int quit(u_long param = 0)
    {
        return this->stop_equipments(param);
    }

//
    int  parse_xml(const char * hostcmd, size_t cmdsize);
    int  parse_vfei(const char * hostcmd, size_t cmdsize);
    int  request(host_cmd * cmd);

    int  storeReport(const string& filename, const string& msgbody,
                     UINT top = 0);
    size_t maxMessageSize() { return 4096; }
    const char * getErrorText(int errcode);

    // VFEI Commands
    int abort(const std::string& mid, int tid, const std::string& port,
                    int level = 0);
    int alarm_report(const std::string& mid, int alid, BYTE alstate,
                    const std::string& altx = "", BYTE alcd = 0,
                    int errcode = 0, const std::string& errtext = "");
    int alarm_setup(const std::string& mid, int tid, bool aled,
                    const std::vector<std::string>& alids);
    int command_ack(const std::string& mid, int tid, int errcode = 0,
                    const std::string& errtext = "");
    int display(const std::string& mid, int tid, BYTE terminal,
                    const std::string& text = "");
    int event_report(const std::string& mid, const std::string& ceid,
                    const std::string& user, const std::string& file = "",
                    int errcode = 0, const std::string& errtext = "");
    int event_setup(const std::string& mid, int tid, bool ceed,
                    const std::vector<std::string>& ceids,
                    const std::vector<std::string>& vids,
                    const std::string& dir = "");
    int initialize(const std::string& mid, int tid);
    int machine_command(const std::string& mid, int tid,
                    const std::string& cmdtype,
                    const std::vector<any_item>& params);
    int move_command(const std::string& mid, int tid,
                    const std::string& tgtype = "",
                    const std::string& tgid = "",
                    const std::string& src_loc = "",
                    const std::string& dest_loc = "",
                    const std::string& src_port = "",
                    const std::string& dest_port = "");
    int pause(const std::string& mid, int tid, const std::string& port);
    int resource_activate(const std::string& mid, int tid,
                    const std::string& type,
                    const std::vector<std::string>& resids,
                    const std::vector<any_item>& params);
    int resource_deactivate(const std::string& mid, int tid,
                    const std::string& type,
                    const std::vector<std::string>& resids);
    int resource_delete(const std::string& mid, int tid, const std::string& typ,
                    const std::vector<std::string>& resids);
    int resource_list(const std::string& mid, int tid, const std::string& type,
                    const std::vector<std::string>& resids,
                    const std::string& file,
                    int errcode = 0, const std::string& errtext = "");
    int resource_query(const std::string& mid, int tid, const std::string& type,
                    const std::vector<std::string>& resids,
                    const std::string& file = "");
    int resource_request(const std::string& mid, int tid,
                    const std::string& type,
                    const std::vector<std::string>& resids,
                    const std::string& file = "");
    int resource_transfer(const std::string& mid, int tid,
                    const std::string& type, const std::string& resid,
                    size_t length, const char * body = NULL);
    int restart(const std::string& mid, int errcode = 0,
                const std::string& errtext = "");
    int resume(const std::string& mid, int tid, const std::string& port,
                    const std::vector<any_item>& params);
    int set_param(const std::string& mid, int tid, const std::string& res_type,
                    const std::vector<any_item>& params);
    int start(const std::string& mid, int tid, const std::string& port,
              const std::string& lotid, int mbc_size,
              const std::vector<any_item>& params);
    int status_list(const std::string& mid, int tid,
                    const std::string& status, const std::string& file = "",
                    int errcode = 0, const std::string& errtext = "");
    int status_query(const std::string& mid, int tid,
                    const std::vector<std::string>& vids, const std::string& file = "");
    int trace_report(const std::string& mid, int tid, int trace_id,
                    size_t report_length, const std::string& rpt,
                    const std::string& file = "",
                    int errcode = 0, const std::string& errtext = "");
    int trace_setup(const std::string& mid, int tid, bool enable, int trace_id,
                    size_t frequency, size_t samples, size_t report_size,
                    const std::vector<std::string>& vids, const std::string& dir = "");

    void dump() const;
//
    static HSMainManager * instance();
    static HSMainManager * instance(const BCHAR * name,const BCHAR * logParam = NULL);
    static HSMainManager * instance(HSMainManager * app);
//
protected:
    HSDevice * m_hostcom;
};

#endif
