// $Id$

//=============================================================================
/**
 *  @file    HSServer.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSSERVER_H
#define HSSERVER_H

#include "jyugem/gem/JGEquipment.h"
#include "jyugem/gem/rcmd.h"
using namespace jyugem::cell;

// Forward declaration
class HSSECSDevice;
class HSInitializeCmd;
class HSProcProgManager;

typedef jyugem::cell::rcmd host_cmd;


/*
 * Host Simulator's Command manager class
 */
class BEE_Export HSServer: public JGEquipment
{
public:
    HSServer(const string& name = _TX("DEVICE_SERVER"))
        : JGEquipment(name), m_initcmd(NULL)
    {
        m_server = true;
    }
    virtual ~HSServer() {}

    virtual int init(void * argv = 0);
    virtual int svc(void);

    int entryInitializeCmdModue(void * param);

    int request(const host_cmd& cmd);

    int reqOnline();
    int abort(int tid, const std::string& port, int level = 0);
    int alarm_report(int alid, BYTE alstate, const std::string& altx = "",
                     BYTE alcd = 0,
                     int errcode = 0, const std::string& errtext = "");
    int alarm_setup(int tid, bool aled, const std::vector<std::string>& alids);
    int command_ack(int tid, int errcode = 0, const std::string& errtext = "");
    int display(int tid, BYTE terminal, const std::string& text = "");
    int event_report(const std::string& ceid, const std::string& rpt,
                     const std::string& file = "",
                     int errcode = 0, const std::string& errtext = "");
    int event_setup(int tid, bool ceed, const std::vector<std::string>& ceids,
                    const std::vector<std::string>& vids,
                    const std::string& dir = "");
    int initialize(int tid);
    int machine_command(int tid, const std::string& cmdtype,
                        const std::vector<any_item>& params);
    int move_command(int tid, const std::string& tgtype = "",
                 const std::string& tgid = "", const std::string& src_loc = "",
                 const std::string& dst_loc = "", const std::string& sport = "",
                 const std::string& dport = "");
    int pause(int tid, const std::string& port);
    int resource_activate(int tid, const std::string& type,
                          const std::vector<std::string>& resids,
                          const std::vector<any_item>& params);
    int resource_deactivate(int tid, const std::string& type,
                            const std::vector<std::string>& resids);
    int resource_delete(int tid, const std::string& type,
                        const std::vector<std::string>& resids);
    int resource_list(int tid, const std::string& type,
                      const std::vector<std::string>& resids,
                      const std::string& file,
                      int errcode = 0, const std::string& errtext = "");
    int resource_query(int tid, const std::string& type,
                       const std::vector<std::string>& resids,
                       const std::string& file = "");
    int resource_request(int tid, const std::string& type,
                         const std::vector<std::string>& resids,
                         const std::string& file = "");
    int resource_transfer(int tid, const std::string& type,
                          const std::string& resid, size_t length,
                          const char * body = NULL);
    int restart(int errcode = 0, const std::string& errtext = "");
    int resume(int tid, const std::string& port,
               const std::vector<any_item>& params);
    int set_param(int tid, const std::string& res_type,
                  const std::vector<any_item>& params);
    int start(int tid, const std::string& port, const std::string& lotid,
              int mbc_size, const std::vector<any_item>& params);
    int status_list(int tid, const std::string& rpt,
                    const std::string& file = "",
                    int errcode = 0, const std::string& errtext = "");
    int status_query(int tid, const std::vector<std::string>& vids,
                     const std::string& file = "");
    int trace_report(int tid, int trace_id, size_t report_length,
                     const std::string& rpt, const std::string& file = "",
                     int errcode = 0, const std::string& errtext = "");
    int trace_setup(int tid, bool enable, int trace_id, size_t frequency,
                    size_t samples, size_t report_size,
                    const std::vector<std::string>& vids,
                    const std::string& dir = "");

protected:
    HSSECSDevice * initDevice();

    HSSECSDevice * m_devptr;
    HSInitializeCmd * m_initcmd;
    HSProcProgManager * m_pp_mngr;
};

#endif
