// $Id$

//=============================================================================
/**
 *  @file    HSSpoolManager.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "HSSpoolManager.h"
#include "HSServer.h"
#include "HSInfoManager.h"
#include "jyugem/gem/JGTimeModule.h"
#include "jyugem/gem/JGTaskTrigger.h"
#include "jyugem/gem/JGFile.h"
#include "BS2ACKMessage.h"
#include "BS2ErrorMessage.h"
#include "BS2MessageDictionary.h"
#include "BS2ListItem.h"
#include "BS2DeclAtoms.h"
#include "BS2Driver.h"
#include "BS2Stream.h"

static HSSpoolManager * _manager = NULL;

//-----------------------------------------------------------------------------
// Constructor/Destructor
//-----------------------------------------------------------------------------
HSSpoolManager::HSSpoolManager() : JGSpoolManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSSpoolManager::HSSpoolManager");

}

//-----------------------------------------------------------------------------
HSSpoolManager::~HSSpoolManager()
{
    TRACE_FUNCTION(TRL_CONSTRUCT, "HSSpoolManager::~HSSpoolManager");

}

//-----------------------------------------------------------------------------
// Return own.
//-----------------------------------------------------------------------------
HSSpoolManager * HSSpoolManager::instance()
{
    TRACE_FUNCTION(TRL_LOW, "HSSpoolManager::instance");
    if (_manager == NULL)
    {
        _manager = new HSSpoolManager;
    }
    return _manager;
}

//-----------------------------------------------------------------------------
// Initialize variables for spool.
//-----------------------------------------------------------------------------
int HSSpoolManager::init(void * parm)
{
    TRACE_FUNCTION(TRL_LOW, "HSSpoolManager::init");
    ACE_UNUSED_ARG(parm);

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Entry spooling stream-function number
//-----------------------------------------------------------------------------
int HSSpoolManager::entry(int sfnum)
{
    TRACE_FUNCTION(TRL_LOW, "HSSpoolManager::entry");

    return BEE_SUCCESS;
}

//-----------------------------------------------------------------------------
// Enable/Disable Stream-Function (S2F43 -> S2F44)
//-----------------------------------------------------------------------------
int HSSpoolManager::setupSpool(bool tf, vector<int>& sfs)
{
    TRACE_FUNCTION(TRL_LOW, "HSSpoolManager::setupSpool");

    BS2Message  * msg = BS2Message::factory(SFCODE(2,43));
    BS2ListItem * rootlist = new BS2ListItem;
    msg->add(rootlist);

    BS2ListItem * sflist = new BS2ListItem;
    BS2Item * item;
    for (size_t i = 0; i < sfs.size(); i++)
    {
        item = BS2Item::factory(_TX("STRID"), new BS2Int4(sfs[i] >> 8));
        item = BS2Item::factory(_TX("FCNID"), new BS2Int4(sfs[i] & 0xFF));
    }

    rootlist->add(sflist);
    this->send(msg);
    return 0;
}


//-----------------------------------------------------------------------------
//
// Thread of received trigger event.
//
//-----------------------------------------------------------------------------
BS2Message * HSSpoolManager::msg_svc(JGMessageTrigger * trigger,
                                     BS2Message * msg)
{
    BS2Message * replymsg = NULL;

    if (msg->sf() == SFCODE(6,24))
    {
    }
    else if (msg->sf() == SFCODE(2,44))
    {
    }
    else
    {
        if (m_equipment->isCommunicating())
        {   // Unexpected message
            replymsg = this->unrecognized(msg);
        }
        else
        {
            ACE_DEBUG((LM_DEBUG,
                  ACE_TEXT("Spool manager: spooling message (%s).\n"),
                  msg->charName()));
            if (msg->isPrimary())
            {   // request to spool message
                this->input(msg);
            }
        }
    }

    return replymsg;
}


